/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.segment.file.tar.FileAccess;
import org.apache.jackrabbit.oak.segment.file.tar.GraphLoader;
import org.apache.jackrabbit.oak.segment.file.tar.SegmentTarWriter;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexLoader;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.file.tar.index.Index;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntry;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexLoader;
import org.apache.jackrabbit.oak.segment.file.tar.index.InvalidIndexException;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentTarReader
implements SegmentArchiveReader {
    private static final Logger log = LoggerFactory.getLogger(SegmentTarReader.class);
    private static final IndexLoader indexLoader = IndexLoader.newIndexLoader(512);
    private final FileAccess access;
    private final File file;
    private final IOMonitor ioMonitor;
    private final String name;
    private final Index index;
    private volatile Boolean hasGraph;

    public SegmentTarReader(File file, FileAccess access, Index index, IOMonitor ioMonitor) {
        this.access = access;
        this.file = file;
        this.index = index;
        this.name = file.getName();
        this.ioMonitor = ioMonitor;
    }

    @Override
    public Buffer readSegment(long msb, long lsb) throws IOException {
        int i = this.index.findEntry(msb, lsb);
        if (i == -1) {
            return null;
        }
        IndexEntry indexEntry = this.index.entry(i);
        this.ioMonitor.beforeSegmentRead(this.file, msb, lsb, indexEntry.getLength());
        Stopwatch stopwatch = Stopwatch.createStarted();
        Buffer buffer = this.access.read(indexEntry.getPosition(), indexEntry.getLength());
        long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.ioMonitor.afterSegmentRead(this.file, msb, lsb, indexEntry.getLength(), elapsed);
        return buffer;
    }

    @Override
    public boolean containsSegment(long msb, long lsb) {
        return this.index.findEntry(msb, lsb) != -1;
    }

    @Override
    public List<SegmentArchiveEntry> listSegments() {
        IndexEntry[] entries = new IndexEntry[this.index.count()];
        for (int i = 0; i < this.index.count(); ++i) {
            entries[i] = this.index.entry(i);
        }
        Arrays.sort(entries, IndexEntry.POSITION_ORDER);
        return Arrays.asList(entries);
    }

    public static Index loadAndValidateIndex(RandomAccessFile file, String name) throws IOException {
        long length = file.length();
        if (length % 512L != 0L) {
            log.warn("Unable to load index of file {}: Invalid alignment", (Object)name);
            return null;
        }
        if (length < 3072L) {
            log.warn("Unable to load index of file {}: File too short", (Object)name);
            return null;
        }
        if (length > Integer.MAX_VALUE) {
            log.warn("Unable to load index of file {}: File too long", (Object)name);
            return null;
        }
        ReaderAtEnd r = (whence, size) -> {
            Buffer buffer = Buffer.allocate((int)size);
            file.seek(length - 1024L - (long)whence);
            file.readFully(buffer.array());
            return buffer;
        };
        try {
            return indexLoader.loadIndex(r);
        }
        catch (InvalidIndexException e) {
            log.warn("Unable to load index of file {}: {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Buffer getGraph() throws IOException {
        int end = this.access.length() - 1024 - this.getIndexEntrySize();
        Buffer graph = GraphLoader.loadGraph((whence, amount) -> this.access.read(end - whence, amount));
        this.hasGraph = graph != null;
        return graph;
    }

    @Override
    public boolean hasGraph() {
        if (this.hasGraph == null) {
            try {
                this.getGraph();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hasGraph;
    }

    @Override
    public Buffer getBinaryReferences() throws IOException {
        try {
            int end = this.access.length() - 1024 - this.getIndexEntrySize() - this.getGraphEntrySize();
            return BinaryReferencesIndexLoader.loadBinaryReferencesIndex((whence, amount) -> this.access.read(end - whence, amount));
        }
        catch (InvalidBinaryReferencesIndexException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
        this.access.close();
    }

    @Override
    public int getEntrySize(int size) {
        return 512 + size + SegmentTarWriter.getPaddingSize(size);
    }

    private int getIndexEntrySize() {
        return this.getEntrySize(this.index.size());
    }

    private int getGraphEntrySize() {
        Buffer buffer;
        try {
            buffer = this.getGraph();
        }
        catch (IOException e) {
            log.warn("Exception while loading pre-compiled tar graph", (Throwable)e);
            return 0;
        }
        if (buffer == null) {
            return 0;
        }
        return this.getEntrySize(buffer.getInt(buffer.limit() - 8));
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

