/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreUtil;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarRevisions
implements Revisions,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TarRevisions.class);
    private final Lock journalFileLock = new ReentrantLock();
    @NotNull
    private final AtomicReference<RecordId> head;
    private final SegmentNodeStorePersistence persistence;
    private final JournalFile journalFile;
    private volatile JournalFileWriter journalFileWriter;
    @NotNull
    private final AtomicReference<RecordId> persistedHead;
    @NotNull
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    public static final Revisions.Option EXPEDITE_OPTION = new Revisions.Option(){

        public String toString() {
            return "Expedite Option";
        }
    };
    public static final Revisions.Option INFINITY = new TimeOutOption(Long.MAX_VALUE, TimeUnit.DAYS);

    public static Revisions.Option timeout(long time, TimeUnit unit) {
        return new TimeOutOption(time, unit);
    }

    public TarRevisions(SegmentNodeStorePersistence persistence) throws IOException {
        this.journalFile = persistence.getJournalFile();
        this.journalFileWriter = this.journalFile.openJournalWriter();
        this.head = new AtomicReference<Object>(null);
        this.persistedHead = new AtomicReference<Object>(null);
        this.persistence = persistence;
    }

    synchronized void bind(@NotNull SegmentStore store, @NotNull SegmentIdProvider idProvider, @NotNull Supplier<RecordId> writeInitialNode) throws IOException {
        if (this.head.get() != null) {
            return;
        }
        RecordId persistedId = FileStoreUtil.findPersistedRecordId(store, idProvider, this.journalFile);
        if (persistedId == null) {
            this.head.set(writeInitialNode.get());
        } else {
            this.persistedHead.set(persistedId);
            this.head.set(persistedId);
        }
    }

    private void checkBound() {
        Validate.checkState((this.head.get() != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    void flush(Flusher flusher) throws IOException {
        if (this.head.get() == null) {
            LOG.debug("No head available, skipping flush");
            return;
        }
        this.journalFileLock.lock();
        try {
            this.doFlush(flusher);
        }
        finally {
            this.journalFileLock.unlock();
        }
    }

    void tryFlush(Flusher flusher) throws IOException {
        if (this.head.get() == null) {
            LOG.debug("No head available, skipping flush");
            return;
        }
        if (this.journalFileLock.tryLock()) {
            try {
                this.doFlush(flusher);
            }
            finally {
                this.journalFileLock.unlock();
            }
        } else {
            LOG.debug("Unable to lock the journal, skipping flush");
        }
    }

    private void doFlush(Flusher flusher) throws IOException {
        if (this.journalFileWriter == null) {
            LOG.debug("No journal file available, skipping flush");
            return;
        }
        RecordId before = this.persistedHead.get();
        RecordId after = this.getHead();
        if (after.equals(before)) {
            LOG.debug("Head state did not change, skipping flush");
            return;
        }
        flusher.flush();
        LOG.debug("TarMK journal update {} -> {}", (Object)before, (Object)after);
        this.journalFileWriter.writeLine(after.toString10() + " root " + System.currentTimeMillis());
        this.persistedHead.set(after);
    }

    @Override
    @NotNull
    public RecordId getHead() {
        this.checkBound();
        return this.head.get();
    }

    @Override
    @NotNull
    public RecordId getPersistedHead() {
        this.checkBound();
        return this.persistedHead.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHead(@NotNull RecordId expected, @NotNull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        Lock lock = TarRevisions.isExpedited(options) ? this.rwLock.writeLock() : this.rwLock.readLock();
        lock.lock();
        try {
            RecordId id = this.head.get();
            boolean bl = id.equals(expected) && this.head.compareAndSet(id, head);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordId setHead(@NotNull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        this.checkBound();
        TimeOutOption timeout = TarRevisions.getTimeout(options);
        if (this.rwLock.writeLock().tryLock(timeout.time, timeout.unit)) {
            try {
                RecordId after = newHead.apply(this.getHead());
                if (after != null) {
                    this.head.set(after);
                    RecordId recordId = after;
                    return recordId;
                }
                RecordId recordId = null;
                return recordId;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        return null;
    }

    private static boolean isExpedited(Revisions.Option[] options) {
        if (options.length == 0) {
            return false;
        }
        if (options.length == 1) {
            return options[0] == EXPEDITE_OPTION;
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @NotNull
    private static TimeOutOption getTimeout(@NotNull Revisions.Option[] options) {
        if (options.length == 0) {
            return TimeOutOption.from(INFINITY);
        }
        if (options.length == 1) {
            return TimeOutOption.from(options[0]);
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @Override
    public void close() throws IOException {
        this.journalFileLock.lock();
        try {
            if (this.journalFileWriter == null) {
                return;
            }
            this.journalFileWriter.close();
            this.journalFileWriter = null;
        }
        finally {
            this.journalFileLock.unlock();
        }
    }

    private static class TimeOutOption
    implements Revisions.Option {
        private final long time;
        @NotNull
        private final TimeUnit unit;

        TimeOutOption(long time, @NotNull TimeUnit unit) {
            this.time = time;
            this.unit = unit;
        }

        @NotNull
        public static TimeOutOption from(@Nullable Revisions.Option option) {
            if (option instanceof TimeOutOption) {
                return (TimeOutOption)option;
            }
            throw new IllegalArgumentException("Invalid option " + option);
        }
    }
}

