/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.silverstatistics.volume.dao.AbstractSilverStatisticsDAO;
import org.silverpeas.core.silverstatistics.volume.model.StatDataType;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticMode;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsConfig;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverStatisticsManagerDAO
extends AbstractSilverStatisticsDAO {
    private static final String CUMUL = "Cumul";

    private SilverStatisticsManagerDAO() {
    }

    public static void insertDataStatsCumul(Connection con, StatType statsType, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        SilverStatisticsManagerDAO.insertData(con, conf.getTableName(statsType) + CUMUL, statsType, valueKeys, conf);
    }

    public static void putDataStatsCumul(Connection con, StatType statsType, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        String tableName = conf.getTableName(statsType);
        AbstractSilverStatisticsDAO.Statements statements = SilverStatisticsManagerDAO.computeStatements(tableName + CUMUL, statsType, valueKeys, conf);
        String selectStatement = statements.getSelectStatement();
        String updateStatement = statements.getUpdateStatement();
        List<String> theKeys = statements.getKeys();
        boolean rowExist = false;
        try (Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(selectStatement);
             PreparedStatement pstmt = con.prepareStatement(updateStatement);){
            while (rs.next()) {
                rowExist = true;
                SilverStatisticsManagerDAO.initUpdateStatement(pstmt, rs, statsType, theKeys, valueKeys, conf);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error((Throwable)e);
            throw e;
        }
        finally {
            if (!rowExist) {
                SilverStatisticsManagerDAO.insertDataStatsCumul(con, statsType, valueKeys, conf);
            }
        }
    }

    private static void initUpdateStatement(PreparedStatement pstmt, ResultSet rs, StatType statsType, List<String> theKeys, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        int countCumulKey = 0;
        for (String keyNameCurrent : theKeys) {
            if (!conf.isCumulKey(statsType, keyNameCurrent)) continue;
            ++countCumulKey;
            StatDataType currentType = StatDataType.valueOf(conf.getKeyType(statsType, keyNameCurrent));
            if (StatDataType.INTEGER == currentType) {
                SilverStatisticsManagerDAO.setUpdateStatementIntParam(pstmt, rs, statsType, valueKeys, conf, countCumulKey, keyNameCurrent);
            }
            if (StatDataType.DECIMAL != currentType) continue;
            SilverStatisticsManagerDAO.setUpdateStatementLongParam(pstmt, rs, statsType, valueKeys, conf, countCumulKey, keyNameCurrent);
        }
    }

    private static void setUpdateStatementLongParam(PreparedStatement pstmt, ResultSet rs, StatType statsType, List<String> valueKeys, StatisticsConfig conf, int countCumulKey, String keyNameCurrent) throws SQLException {
        long myLong = Long.parseLong(valueKeys.get(conf.indexOfKey(statsType, keyNameCurrent)));
        if (conf.getModeCumul(statsType) == StatisticMode.Add) {
            pstmt.setLong(countCumulKey, rs.getLong(keyNameCurrent) + myLong);
        }
        if (conf.getModeCumul(statsType) == StatisticMode.Replace) {
            pstmt.setLong(countCumulKey, myLong);
        }
    }

    private static void setUpdateStatementIntParam(PreparedStatement pstmt, ResultSet rs, StatType statsType, List<String> valueKeys, StatisticsConfig conf, int countCumulKey, String keyNameCurrent) throws SQLException {
        int intToAdd = Integer.parseInt(valueKeys.get(conf.indexOfKey(statsType, keyNameCurrent)));
        if (conf.getModeCumul(statsType) == StatisticMode.Add) {
            pstmt.setInt(countCumulKey, rs.getInt(keyNameCurrent) + intToAdd);
        }
        if (conf.getModeCumul(statsType) == StatisticMode.Replace) {
            pstmt.setInt(countCumulKey, intToAdd);
        }
    }

    public static void makeStatCumul(Connection con, StatType statsType, StatisticsConfig conf) {
        String selectStatement = "SELECT * FROM " + conf.getTableName(statsType);
        try (Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(selectStatement);){
            List<String> theKeys = conf.getAllKeys(statsType);
            while (rs.next()) {
                ArrayList<String> valueKeys = new ArrayList<String>();
                Iterator iterator = theKeys.iterator();
                while (iterator.hasNext()) {
                    String theKey;
                    String keyNameCurrent = theKey = (String)iterator.next();
                    StatDataType currentType = StatDataType.valueOf(conf.getKeyType(statsType, keyNameCurrent));
                    String addToValueKeys = SilverStatisticsManagerDAO.getValueKey(rs, keyNameCurrent, currentType);
                    valueKeys.add(addToValueKeys);
                }
                SilverStatisticsManagerDAO.putDataStatsCumul(con, statsType, valueKeys, conf);
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error("Error while making stat cummul", (Throwable)e);
        }
    }

    @Nonnull
    private static String getValueKey(ResultSet rs, String keyNameCurrent, StatDataType currentType) throws SQLException {
        String valueKey;
        switch (currentType) {
            case INTEGER: {
                int tmpInt = rs.getInt(keyNameCurrent);
                if (rs.wasNull()) {
                    valueKey = "";
                    break;
                }
                valueKey = String.valueOf(tmpInt);
                break;
            }
            case DECIMAL: {
                long longValue = rs.getLong(keyNameCurrent);
                if (rs.wasNull()) {
                    valueKey = "";
                    break;
                }
                valueKey = String.valueOf(longValue);
                break;
            }
            case VARCHAR: {
                String value = rs.getString(keyNameCurrent);
                valueKey = Objects.requireNonNullElse(value, "");
                break;
            }
            default: {
                valueKey = "";
            }
        }
        return valueKey;
    }

    static void deleteTablesOfTheDay(Connection con, StatType statsType, StatisticsConfig conf) {
        String deleteStatement = "DELETE FROM " + conf.getTableName(statsType);
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error("Error while deleting tables of the day", (Throwable)e);
        }
    }

    static void purgeTablesCumul(Connection con, StatType statsType, StatisticsConfig conf) {
        StringBuilder deleteStatementBuf = new StringBuilder("DELETE FROM " + conf.getTableName(statsType) + "Cumul WHERE dateStat<");
        Calendar dateOfTheDay = Calendar.getInstance();
        dateOfTheDay.add(2, -conf.getPurge(statsType));
        deleteStatementBuf.append(SilverStatisticsManagerDAO.getRequestDate(dateOfTheDay.get(1), dateOfTheDay.get(2) + 1));
        String deleteStatement = deleteStatementBuf.toString();
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error("Error while purging stat cumul", (Throwable)e);
        }
    }

    static String getRequestDate(int year, int sMonth) {
        StringBuilder dateStringBuf = new StringBuilder();
        Object month = String.valueOf(sMonth);
        if (((String)month).length() < 2) {
            month = "0" + (String)month;
        }
        dateStringBuf.append("'").append(year);
        dateStringBuf.append("-").append((String)month);
        dateStringBuf.append("-01'");
        return dateStringBuf.toString();
    }

    public static void makeStatAllCumul(StatisticsConfig conf) {
        try (Connection con = SilverStatisticsManagerDAO.getConnection();){
            if (conf != null && conf.isValidConfigFile()) {
                for (StatType currentType : conf.getAllTypes()) {
                    SilverStatisticsManagerDAO.purgeTablesCumul(con, currentType, conf);
                    SilverStatisticsManagerDAO.makeStatCumul(con, currentType, conf);
                    SilverStatisticsManagerDAO.deleteTablesOfTheDay(con, currentType, conf);
                }
            } else if (conf == null) {
                SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error("No config file provided", new Object[0]);
            } else if (!conf.isValidConfigFile()) {
                SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error("No valid config file", new Object[0]);
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger(SilverStatisticsManagerDAO.class).error((Throwable)e);
        }
    }

    private static Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new StatisticsRuntimeException(e);
        }
    }
}

