/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.proxy;

import java.net.URL;
import java.net.URLEncoder;
import org.jasig.cas.client.proxy.ProxyRetriever;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cas20ProxyRetriever
implements ProxyRetriever {
    private static final long serialVersionUID = 560409469568911792L;
    private static final Logger logger = LoggerFactory.getLogger(Cas20ProxyRetriever.class);
    private final String casServerUrl;
    private final String encoding;
    private final HttpURLConnectionFactory urlConnectionFactory;

    @Deprecated
    public Cas20ProxyRetriever(String casServerUrl, String encoding) {
        this(casServerUrl, encoding, null);
    }

    public Cas20ProxyRetriever(String casServerUrl, String encoding, HttpURLConnectionFactory urlFactory) {
        CommonUtils.assertNotNull(casServerUrl, "casServerUrl cannot be null.");
        this.casServerUrl = casServerUrl;
        this.encoding = encoding;
        this.urlConnectionFactory = urlFactory;
    }

    public String getProxyTicketIdFor(String proxyGrantingTicketId, String targetService) {
        CommonUtils.assertNotNull(proxyGrantingTicketId, "proxyGrantingTicketId cannot be null.");
        CommonUtils.assertNotNull(targetService, "targetService cannot be null.");
        URL url = this.constructUrl(proxyGrantingTicketId, targetService);
        String response = this.urlConnectionFactory != null ? CommonUtils.getResponseFromServer(url, this.urlConnectionFactory, this.encoding) : CommonUtils.getResponseFromServer(url, this.encoding);
        String error = XmlUtils.getTextForElement(response, "proxyFailure");
        if (CommonUtils.isNotEmpty(error)) {
            logger.debug(error);
            return null;
        }
        return XmlUtils.getTextForElement(response, "proxyTicket");
    }

    private URL constructUrl(String proxyGrantingTicketId, String targetService) {
        try {
            return new URL(this.casServerUrl + (this.casServerUrl.endsWith("/") ? "" : "/") + "proxy" + "?pgt=" + proxyGrantingTicketId + "&targetService=" + URLEncoder.encode(targetService, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

