/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.listeners;

import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.notification.UserEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.chat.servers.DefaultChatServer;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Service
public class ChatUserEventListener
extends CDIResourceEventListener<UserEvent> {
    @Inject
    @DefaultChatServer
    private ChatServer server;

    public void onCreation(UserEvent event) {
        User user = (User)event.getTransition().getAfter();
        if (this.server.isAllowed(user)) {
            this.server.createUser(user);
            this.logger.debug("Chat account have been created for user {0}", new Object[]{user.getId()});
        } else {
            this.logger.debug("No chat account created for user {0}: the user isn't allowed to use the chat service", new Object[]{user.getId()});
        }
    }

    public void onDeletion(UserEvent event) {
        User user = (User)event.getTransition().getBefore();
        if (this.server.isUserExisting(user)) {
            this.server.deleteUser(user);
            this.logger.debug("Chat account have been deleted for user {0}", new Object[]{user.getId()});
        } else {
            this.logger.debug("No chat account deleted for user {0}: no such account in the chat server", new Object[]{user.getId()});
        }
    }

    public boolean isEnabled() {
        return ChatServer.isEnabled();
    }
}

