/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import edu.psu.swe.commons.jaxrs.patch.JsonPointer;
import edu.psu.swe.commons.jaxrs.patch.JsonPointerAdapter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"operation", "path", "value"})
@XmlAccessorType(value=XmlAccessType.NONE)
public class PatchOperation {
    @XmlElement(name="op")
    private Type operation;
    @XmlElement
    @XmlJavaTypeAdapter(value=JsonPointerAdapter.class)
    private JsonPointer path;
    @XmlElement
    private JsonNode value;
    @XmlElement
    @XmlJavaTypeAdapter(value=JsonPointerAdapter.class)
    private JsonPointer from;

    public static PatchOperation add(JsonPointer jsonPointer, JsonNode value) {
        return new PatchOperation(Type.ADD, jsonPointer, value);
    }

    public static PatchOperation add(JsonPointer jsonPointer, boolean value) {
        return PatchOperation.add(jsonPointer, (JsonNode)JsonNodeFactory.instance.booleanNode(value));
    }

    public static PatchOperation add(JsonPointer jsonPointer, long value) {
        return PatchOperation.add(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation add(JsonPointer jsonPointer, double value) {
        return PatchOperation.add(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation add(JsonPointer jsonPointer, String value) {
        return PatchOperation.add(jsonPointer, (JsonNode)JsonNodeFactory.instance.textNode(value));
    }

    public static PatchOperation add(JsonPointer jsonPointer, Object value) {
        return PatchOperation.add(jsonPointer, (JsonNode)JsonNodeFactory.instance.pojoNode(value));
    }

    public static PatchOperation remove(JsonPointer jsonPointer) {
        return new PatchOperation(Type.REMOVE, jsonPointer);
    }

    public static PatchOperation remove(JsonPointer jsonPointer, JsonNode value) {
        return new PatchOperation(Type.REMOVE, jsonPointer, value);
    }

    public static PatchOperation remove(JsonPointer jsonPointer, long value) {
        return new PatchOperation(Type.REMOVE, jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation remove(JsonPointer jsonPointer, double value) {
        return new PatchOperation(Type.REMOVE, jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation remove(JsonPointer jsonPointer, String value) {
        return new PatchOperation(Type.REMOVE, jsonPointer, (JsonNode)JsonNodeFactory.instance.textNode(value));
    }

    public static PatchOperation remove(JsonPointer jsonPointer, Object value) {
        return new PatchOperation(Type.REMOVE, jsonPointer, (JsonNode)JsonNodeFactory.instance.pojoNode(value));
    }

    public static PatchOperation replace(JsonPointer jsonPointer, JsonNode value) {
        return new PatchOperation(Type.REPLACE, jsonPointer, value);
    }

    public static PatchOperation replace(JsonPointer jsonPointer, boolean value) {
        return PatchOperation.replace(jsonPointer, (JsonNode)JsonNodeFactory.instance.booleanNode(value));
    }

    public static PatchOperation replace(JsonPointer jsonPointer, long value) {
        return PatchOperation.replace(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation replace(JsonPointer jsonPointer, double value) {
        return PatchOperation.replace(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation replace(JsonPointer jsonPointer, String value) {
        return PatchOperation.replace(jsonPointer, (JsonNode)JsonNodeFactory.instance.textNode(value));
    }

    public static PatchOperation replace(JsonPointer jsonPointer, Object value) {
        return PatchOperation.replace(jsonPointer, (JsonNode)JsonNodeFactory.instance.pojoNode(value));
    }

    public static PatchOperation test(JsonPointer jsonPointer, JsonNode value) {
        return new PatchOperation(Type.TEST, jsonPointer, value);
    }

    public static PatchOperation test(JsonPointer jsonPointer, boolean value) {
        return PatchOperation.test(jsonPointer, (JsonNode)JsonNodeFactory.instance.booleanNode(value));
    }

    public static PatchOperation test(JsonPointer jsonPointer, long value) {
        return PatchOperation.test(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation test(JsonPointer jsonPointer, double value) {
        return PatchOperation.test(jsonPointer, (JsonNode)JsonNodeFactory.instance.numberNode(value));
    }

    public static PatchOperation test(JsonPointer jsonPointer, String value) {
        return PatchOperation.test(jsonPointer, (JsonNode)JsonNodeFactory.instance.textNode(value));
    }

    public static PatchOperation test(JsonPointer jsonPointer, Object value) {
        return PatchOperation.test(jsonPointer, (JsonNode)JsonNodeFactory.instance.pojoNode(value));
    }

    protected PatchOperation() {
    }

    protected PatchOperation(Type type, JsonPointer pointer, JsonNode value) {
        this.operation = type;
        this.path = pointer;
        this.value = value;
    }

    protected PatchOperation(Type type, JsonPointer pointer) {
        this.operation = type;
        this.path = pointer;
    }

    public Type getOperation() {
        return this.operation;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public JsonPointer getFrom() {
        return this.from;
    }

    public void setOperation(Type operation) {
        this.operation = operation;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public void setFrom(JsonPointer from) {
        this.from = from;
    }

    public String toString() {
        return "PatchOperation(operation=" + (Object)((Object)this.getOperation()) + ", path=" + this.getPath() + ", value=" + this.getValue() + ", from=" + this.getFrom() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatchOperation)) {
            return false;
        }
        PatchOperation other = (PatchOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$operation = this.getOperation();
        Type other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        JsonPointer this$path = this.getPath();
        JsonPointer other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        JsonNode this$value = this.getValue();
        JsonNode other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        JsonPointer this$from = this.getFrom();
        JsonPointer other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !((Object)this$from).equals(other$from));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PatchOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        JsonPointer $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        JsonNode $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        JsonPointer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        return result;
    }

    @XmlEnum(value=String.class)
    public static enum Type {
        ADD,
        COPY,
        MOVE,
        REMOVE,
        REPLACE,
        TEST;

    }
}

