/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.silverpeas.kernel.BeanContainer;
import org.silverpeas.kernel.exception.ExpectationViolationException;
import org.silverpeas.kernel.exception.MultipleCandidateException;

public class CDIContainer
implements BeanContainer {
    public <T> Optional<T> getBeanByName(String name) throws IllegalStateException {
        BeanManager beanManager = CDI.current().getBeanManager();
        try {
            Bean bean = beanManager.resolve(beanManager.getBeans(name));
            if (bean == null) {
                return Optional.empty();
            }
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            Type type = (Type)bean.getTypes().stream().findFirst().orElseThrow(() -> new ExpectationViolationException("The bean " + name + " doesn't satisfy any managed type"));
            return Optional.ofNullable(beanManager.getReference(bean, type, ctx));
        }
        catch (AmbiguousResolutionException e) {
            throw new MultipleCandidateException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public <T> Optional<T> getBeanByType(Class<T> type, Annotation ... qualifiers) throws IllegalStateException {
        BeanManager beanManager = CDI.current().getBeanManager();
        try {
            Bean bean = beanManager.resolve(beanManager.getBeans(type, qualifiers));
            if (bean == null) {
                return Optional.empty();
            }
            CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
            return Optional.ofNullable(beanManager.getReference(bean, type, ctx));
        }
        catch (AmbiguousResolutionException e) {
            throw new MultipleCandidateException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ExpectationViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public <T> Set<T> getAllBeansByType(Class<T> type, Annotation ... qualifiers) {
        BeanManager beanManager = CDI.current().getBeanManager();
        try {
            return beanManager.getBeans(type, qualifiers).stream().map(bean -> {
                CreationalContext ctx = beanManager.createCreationalContext((Contextual)bean);
                return beanManager.getReference(bean, (Type)type, ctx);
            }).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new ExpectationViolationException(e.getMessage(), (Throwable)e);
        }
    }
}

