/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.AbstractSubscription;
import org.silverpeas.core.subscription.service.ComponentSubscription;
import org.silverpeas.core.subscription.service.ComponentSubscriptionResource;
import org.silverpeas.core.subscription.service.NodeSubscription;
import org.silverpeas.core.subscription.service.NodeSubscriptionResource;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

@Provider
@Singleton
public class SubscriptionFactory {
    private final Map<String, SubscriptionResourceType> registry = new ConcurrentHashMap<String, SubscriptionResourceType>();
    private final Map<String, SubscriptionResourceConstructor> subscriptionResourceConstructorRegistry = new ConcurrentHashMap<String, SubscriptionResourceConstructor>();
    private final Map<String, SubscriptionConstructor> subscriptionConstructorRegistry = new ConcurrentHashMap<String, SubscriptionConstructor>();

    public static SubscriptionFactory get() {
        return (SubscriptionFactory)ServiceProvider.getService(SubscriptionFactory.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    protected void setupDefaults() {
        this.register(CommonSubscriptionResourceConstants.COMPONENT, (r, s, i) -> ComponentSubscriptionResource.from(i), (s, r, c) -> new ComponentSubscription(s, (ComponentSubscriptionResource)r, c));
        this.register(CommonSubscriptionResourceConstants.NODE, (r, s, i) -> NodeSubscriptionResource.from(new NodePK(r, s, i)), (s, r, c) -> new NodeSubscription(s, (NodeSubscriptionResource)r, c));
    }

    private SubscriptionFactory() {
    }

    public void register(SubscriptionResourceType type, SubscriptionResourceConstructor srConstructor, SubscriptionConstructor sConstructor) {
        if (type.isValid()) {
            this.registry.put(type.getName(), type);
            this.subscriptionResourceConstructorRegistry.put(type.getName(), srConstructor);
            this.subscriptionConstructorRegistry.put(type.getName(), sConstructor);
        }
    }

    public SubscriptionResourceType getSubscriptionResourceTypeByName(String name) {
        return StringUtil.isDefined((String)name) ? this.registry.getOrDefault(name, CommonSubscriptionResourceConstants.UNKNOWN) : CommonSubscriptionResourceConstants.UNKNOWN;
    }

    public SubscriptionResource createSubscriptionResourceInstance(SubscriptionResourceType type, String resourceId, String space, String instanceId) {
        return Optional.ofNullable(this.subscriptionResourceConstructorRegistry.get(type.getName())).map(c -> c.create(resourceId, space, instanceId)).orElse(null);
    }

    public <R extends SubscriptionResource> AbstractSubscription<R> createSubscriptionInstance(SubscriptionSubscriber subscriber, R resource, String creatorId) {
        return Optional.ofNullable(this.subscriptionConstructorRegistry.get(resource.getType().getName())).map(c -> c.create(subscriber, resource, creatorId)).orElse(null);
    }

    public Stream<SubscriptionResourceType> streamAll() {
        return this.registry.values().stream().sorted(Comparator.comparingInt(SubscriptionResourceType::priority).thenComparing(SubscriptionResourceType::getName));
    }

    @FunctionalInterface
    public static interface SubscriptionConstructor<R extends SubscriptionResource> {
        public AbstractSubscription<R> create(SubscriptionSubscriber var1, R var2, String var3);
    }

    @FunctionalInterface
    public static interface SubscriptionResourceConstructor {
        public SubscriptionResource create(String var1, String var2, String var3);
    }
}

