/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Date;
import org.silverpeas.core.date.Period;
import org.silverpeas.kernel.util.StringUtil;

public enum TermsOfServiceAcceptanceFrequency {
    NEVER(null),
    ONE(null),
    DAILY(ChronoUnit.DAYS),
    WEEKLY(ChronoUnit.WEEKS),
    MONTHLY(ChronoUnit.MONTHS),
    YEARLY(ChronoUnit.YEARS),
    ALWAYS(ChronoUnit.FOREVER);

    private final ChronoUnit periodType;

    private TermsOfServiceAcceptanceFrequency(ChronoUnit periodType) {
        this.periodType = periodType;
    }

    public boolean isActivated() {
        return this != NEVER;
    }

    public boolean isAcceptanceDateExpired(Date tosAcceptanceDate) {
        LocalDate acceptanceDate = tosAcceptanceDate == null ? null : LocalDate.ofInstant(tosAcceptanceDate.toInstant(), ZoneId.systemDefault());
        return this.isAcceptanceDateExpired(LocalDate.now(), acceptanceDate);
    }

    private boolean isAcceptanceDateExpired(LocalDate referenceDate, LocalDate tosAcceptanceDate) {
        switch (this) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case ONE: {
                if (tosAcceptanceDate == null) break;
                return false;
            }
            default: {
                if (tosAcceptanceDate == null) break;
                Period validPeriod = Period.from((Temporal)referenceDate).of(1L, this.periodType);
                return !validPeriod.includes((Temporal)tosAcceptanceDate);
            }
        }
        return true;
    }

    public static TermsOfServiceAcceptanceFrequency decode(String tosAcceptanceFrequency) {
        if (StringUtil.isDefined((String)tosAcceptanceFrequency)) {
            for (TermsOfServiceAcceptanceFrequency current : TermsOfServiceAcceptanceFrequency.values()) {
                if (!current.name().equalsIgnoreCase(tosAcceptanceFrequency)) continue;
                return current;
            }
        }
        return NEVER;
    }
}

