/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password.rule;

import org.silverpeas.core.security.authentication.password.constant.PasswordRuleType;
import org.silverpeas.core.security.authentication.password.rule.AbstractPasswordRule;
import org.silverpeas.kernel.util.StringUtil;

public class MinLengthPasswordRule
extends AbstractPasswordRule {
    private Integer value = settings.getInteger(this.getType().getSettingKey(), 8);

    public MinLengthPasswordRule() {
        super(PasswordRuleType.MIN_LENGTH);
        if (settings.getInteger(PasswordRuleType.MAX_LENGTH.getSettingKey() + ".value", 8) < this.value) {
            this.value = 8;
        }
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined((String)password) && password.length() >= this.getValue();
    }

    @Override
    public String random() {
        return "";
    }
}

