/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.security.authentication.AuthDomain;
import org.silverpeas.core.security.authentication.Authentication;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.AuthenticationServer;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationHostException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordMustBeChangedAtNextLogon;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordMustBeChangedOnFirstLogin;
import org.silverpeas.core.security.authentication.exception.AuthenticationPwdNotAvailException;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserAccountBlockedException;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserAccountDeactivatedException;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class AuthenticationService
implements Authentication {
    private static final String DATA_SOURCE_JNDI_NAME;
    private static final String DOMAIN_TABLE_NAME;
    private static final String DOMAIN_ID_COLUMN_NAME;
    private static final String DOMAIN_AUTHENTICATION_SERVER_COLUMN_NAME;
    private static final String KEY_STORE_TABLE_NAME;
    private static final String KEY_STORE_KEY_COLUMN_NAME;
    private static final String KEY_STORE_LOGIN_COLUMN_NAME;
    private static final String KEY_STORE_DOMAIN_ID_COLUMN_NAME;
    private static final String USER_TABLE_NAME;
    private static final String USER_ID_COLUMN_NAME;
    private static final String USER_LOGIN_COLUMN_NAME;
    private static final String USER_DOMAIN_COLUMN_NAME;
    private static int autoInc;
    @Inject
    private AdminController adminController;
    private static final Predicate<Domain> DOMAIN_WITH_AUTHENTICATION_SERVER;

    protected AuthenticationService() {
    }

    private static Connection openConnection() throws AuthenticationException {
        Connection connection;
        try {
            DataSource dataSource = (DataSource)InitialContext.doLookup(DATA_SOURCE_JNDI_NAME);
            connection = dataSource.getConnection();
        }
        catch (Exception iex) {
            throw new AuthenticationHostException("Connection failure with datasource " + DATA_SOURCE_JNDI_NAME, (Throwable)iex);
        }
        return connection;
    }

    private static void closeConnection(Connection con) {
        DBUtil.close((Connection)con);
    }

    @Nonnull
    public List<AuthDomain> getAllAuthDomains() {
        List<AuthDomain> domains;
        try {
            domains = Arrays.stream(Administration.get().getAllDomains()).filter(DOMAIN_WITH_AUTHENTICATION_SERVER).collect(Collectors.toList());
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            domains = Collections.emptyList();
        }
        return domains;
    }

    public AuthenticationResponse authenticate(AuthenticationCredential userCredential) {
        AuthenticationResponse result;
        try {
            String token = this.checkAuthentication(userCredential);
            result = AuthenticationResponse.succeed((String)token);
        }
        catch (AuthenticationBadCredentialException e) {
            result = this.isThereMultipleDomainsDefined() ? AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.BAD_LOGIN_PASSWORD_DOMAIN) : AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.BAD_LOGIN_PASSWORD);
        }
        catch (AuthenticationPwdNotAvailException e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.NO_PASSWORD);
        }
        catch (AuthenticationPasswordExpired e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.PASSWORD_EXPIRED);
        }
        catch (AuthenticationPasswordMustBeChangedAtNextLogon e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.PASSWORD_TO_CHANGE);
        }
        catch (AuthenticationPasswordMustBeChangedOnFirstLogin e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.PASSWORD_TO_CHANGE_ON_FIRST_LOGIN);
        }
        catch (AuthenticationUserAccountBlockedException e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.USER_ACCOUNT_BLOCKED);
        }
        catch (AuthenticationUserAccountDeactivatedException e) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.USER_ACCOUNT_DEACTIVATED);
        }
        catch (AuthenticationException ae) {
            result = AuthenticationResponse.error((AuthenticationResponse.Status)AuthenticationResponse.Status.UNKNOWN_FAILURE);
        }
        if (!result.getStatus().succeeded()) {
            SilverLogger.getLogger((Object)this).error("authentication error ({0}) with login ''{1}'' and domain id ''{2}''", new Object[]{result.getStatus().toString(), userCredential.getLogin(), userCredential.getDomainId()});
        }
        return result;
    }

    private String checkAuthentication(AuthenticationCredential userCredential) throws AuthenticationException {
        String key = userCredential.hasBeenRemotelyAuthenticated() ? this.authenticateByLoginAndDomain(userCredential) : this.authenticateByLoginAndPasswordAndDomain(userCredential);
        return key;
    }

    private String authenticateByLoginAndPasswordAndDomain(AuthenticationCredential credential) throws AuthenticationException {
        String string;
        block9: {
            String password = credential.getPassword();
            String domainId = credential.getDomainId();
            if (password == null || domainId == null) {
                throw new AuthenticationPwdNotAvailException("No password or no domain is specified!", new String[0]);
            }
            AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
            Connection connection = AuthenticationService.openConnection();
            try {
                AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
                credential.getCapabilities().put("Svp_Password_Change_Allowed", authenticationServer.isPasswordChangeAllowed() ? "yes" : "no");
                authenticationServer.authenticate(credential);
                string = this.getAuthToken(credential);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                    throw new AuthenticationException((Throwable)e);
                }
            }
            connection.close();
        }
        return string;
    }

    private String authenticateByLoginAndDomain(AuthenticationCredential credential) throws AuthenticationException {
        boolean authenticationOK;
        String login = credential.getLogin();
        String domainId = credential.getDomainId();
        if (domainId == null) {
            throw new AuthenticationException("No domain is specified!", new String[0]);
        }
        try (Connection connection = AuthenticationService.openConnection();){
            JdbcSqlQuery query = JdbcSqlQuery.select((String)USER_ID_COLUMN_NAME).from(new String[]{USER_TABLE_NAME}).where(USER_DOMAIN_COLUMN_NAME + " = ?", new Object[]{Integer.parseInt(domainId)});
            if (credential.loginIgnoreCase()) {
                query.and("lower(" + USER_LOGIN_COLUMN_NAME + ") = lower(?)", new Object[]{login});
            } else {
                query.and(USER_LOGIN_COLUMN_NAME + " = ?", new Object[]{login});
            }
            authenticationOK = !query.executeWith(connection, row -> true).isEmpty();
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).warn((Throwable)ex);
            throw new AuthenticationException((Throwable)ex);
        }
        if (authenticationOK) {
            AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
            try {
                return this.getAuthToken(credential);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
                throw new AuthenticationException((Throwable)e);
            }
        }
        return null;
    }

    public void changePassword(AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        this.changePasswordAndEmail(credential, newPassword, null);
    }

    public void changePasswordAndEmail(AuthenticationCredential credential, String newPassword, String email) throws AuthenticationException {
        String oldPassword = credential.getPassword();
        String domainId = credential.getDomainId();
        if (oldPassword == null || domainId == null || newPassword == null) {
            throw new AuthenticationBadCredentialException("The password or the domain isn't set!", new String[0]);
        }
        UserCanLoginVerifier userCanLoginVerifier = AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential);
        userCanLoginVerifier.verify();
        try (Connection connection = AuthenticationService.openConnection();){
            this.getAuthenticationServer(connection, domainId).changePassword(credential, newPassword);
            AuthenticationUserVerifierFactory.removeFromRequestCache(userCanLoginVerifier.getUser());
        }
        catch (AuthenticationException ex) {
            SilverLogger.getLogger((Object)this).warn((Throwable)ex);
            throw ex;
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        this.onPasswordAndEmailChanged(credential, email);
    }

    public String getAuthToken(AuthenticationCredential credential) {
        String authKey = AuthenticationService.generateTokenFor(credential.getLogin());
        this.storeAuthenticationKey(credential.getLogin(), credential.getDomainId(), authKey);
        return authKey;
    }

    public User getUserByAuthToken(String authToken) throws AuthenticationException {
        Administration admin = Administration.get();
        try {
            String userId = admin.getUserIdByAuthenticationKey(authToken);
            return admin.getUserDetail(userId);
        }
        catch (AdminException e) {
            throw new AuthenticationException((Throwable)((Object)e));
        }
    }

    private String getAuthenticationServerName(Connection con, String domainId) throws AuthenticationException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)DOMAIN_AUTHENTICATION_SERVER_COLUMN_NAME).from(new String[]{DOMAIN_TABLE_NAME}).where(DOMAIN_ID_COLUMN_NAME + " = ?", new Object[]{Integer.parseInt(domainId)});
        try {
            String domainServerName = (String)query.executeUniqueWith(con, row -> {
                String serverName = row.getString(DOMAIN_AUTHENTICATION_SERVER_COLUMN_NAME);
                if (!StringUtil.isDefined((String)serverName)) {
                    throw new SQLException("No server found for domain of id " + domainId);
                }
                return serverName;
            });
            if (StringUtil.isNotDefined((String)domainServerName)) {
                throw new SQLException("No such domain with id " + domainId);
            }
            return domainServerName;
        }
        catch (SQLException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private static String generateTokenFor(String login) {
        long nStart = (long)login.hashCode() * new Date().getTime() * (long)autoInc++;
        Random rand = new Random(nStart);
        int key = rand.nextInt();
        return String.valueOf(key);
    }

    private void storeAuthenticationKey(String login, String domainId, String sKey) {
        Transaction.performInOne(() -> {
            JdbcSqlQuery query = JdbcSqlQuery.insertInto((String)KEY_STORE_TABLE_NAME).withInsertParam(KEY_STORE_KEY_COLUMN_NAME, (Object)Integer.parseInt(sKey)).withInsertParam(KEY_STORE_LOGIN_COLUMN_NAME, (Object)login).withInsertParam(KEY_STORE_DOMAIN_ID_COLUMN_NAME, (Object)Integer.parseInt(domainId));
            try (Connection connection = AuthenticationService.openConnection();){
                query.executeWith(connection);
            }
            catch (SQLException ex) {
                SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnAdding((String)"authentication key for login", (Object)login), (Throwable)ex);
            }
            return null;
        });
    }

    public void resetPassword(AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        String login = credential.getLogin();
        String domainId = credential.getDomainId();
        if (domainId == null || newPassword == null) {
            throw new AuthenticationBadCredentialException("The login, the password or the domain isn't set!", new String[0]);
        }
        AuthenticationUserVerifierFactory.getUserCanLoginVerifier(credential).verify();
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            authenticationServer.resetPassword(login, credential.loginIgnoreCase(), newPassword);
        }
        catch (AuthenticationException ex) {
            SilverLogger.getLogger((Object)this).warn((Throwable)ex);
            throw ex;
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
        this.onPasswordAndEmailChanged(credential, null);
    }

    private void onPasswordAndEmailChanged(AuthenticationCredential credential, String email) throws AuthenticationException {
        UserDetail user = UserDetail.getById(this.adminController.getUserIdByLoginAndDomain(credential.getLogin(), credential.getDomainId()));
        AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(user).notifyPasswordChange();
        UserFull userFull = this.adminController.getUserFull(user.getId());
        userFull.setNbSuccessfulLoginAttempts(0);
        userFull.setLastLoginCredentialUpdateDate(new Date());
        if (StringUtil.isDefined((String)email)) {
            userFull.setEmailAddress(email);
        }
        try {
            this.adminController.updateUserFull(userFull);
        }
        catch (AdminException e) {
            throw new AuthenticationException("Cannot update user full information", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPasswordChangeAllowed(String domainId) {
        Connection connection = null;
        try {
            connection = AuthenticationService.openConnection();
            AuthenticationServer authenticationServer = this.getAuthenticationServer(connection, domainId);
            boolean bl = authenticationServer.isPasswordChangeAllowed();
            return bl;
        }
        catch (AuthenticationException ex) {
            SilverLogger.getLogger((Object)this).warn((Throwable)ex);
        }
        finally {
            AuthenticationService.closeConnection(connection);
        }
        return false;
    }

    private AuthenticationServer getAuthenticationServer(Connection con, String domainId) throws AuthenticationException {
        String authenticationServerName = this.getAuthenticationServerName(con, domainId);
        return AuthenticationServer.getAuthenticationServer(authenticationServerName);
    }

    static {
        autoInc = 1;
        DOMAIN_WITH_AUTHENTICATION_SERVER = d -> {
            AuthenticationServer authenticationServer = AuthenticationServer.getAuthenticationServer(d.getAuthenticationServer());
            return authenticationServer.hasProtocols();
        };
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.domains");
        DATA_SOURCE_JNDI_NAME = settings.getString("SQLDomainDataSourceJNDIName");
        DOMAIN_TABLE_NAME = settings.getString("SQLDomainTableName");
        DOMAIN_ID_COLUMN_NAME = settings.getString("SQLDomainIdColumnName");
        DOMAIN_AUTHENTICATION_SERVER_COLUMN_NAME = settings.getString("SQLDomainAuthenticationServerColumnName");
        KEY_STORE_TABLE_NAME = settings.getString("SQLKeyStoreTableName");
        KEY_STORE_KEY_COLUMN_NAME = settings.getString("SQLKeyStoreKeyColumnName");
        KEY_STORE_LOGIN_COLUMN_NAME = settings.getString("SQLKeyStoreLoginColumnName");
        KEY_STORE_DOMAIN_ID_COLUMN_NAME = settings.getString("SQLKeyStoreDomainIdColumnName");
        USER_TABLE_NAME = settings.getString("SQLUserTableName");
        USER_ID_COLUMN_NAME = settings.getString("SQLUserIdColumnName");
        USER_LOGIN_COLUMN_NAME = settings.getString("SQLUserLoginColumnName");
        USER_DOMAIN_COLUMN_NAME = settings.getString("SQLUserDomainColumnName");
    }
}

