/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.silverpeas.core.security.authentication.AuthenticationConnection;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationProtocol;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationHostException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPwdNotAvailException;
import org.silverpeas.core.security.authentication.password.PasswordEncryption;
import org.silverpeas.core.security.authentication.password.PasswordEncryptionProvider;
import org.silverpeas.core.security.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.security.encryption.cipher.CryptMD5;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class AuthenticationSQL
extends AuthenticationProtocol {
    protected String dataSourceJndiName;
    protected String userTableName;
    protected String loginColumnName;
    protected String passwordColumnName;
    protected String passwordAvailableColumnName;

    @Override
    public void loadProperties(SettingBundle settings) {
        String serverName = this.getServerName();
        this.dataSourceJndiName = settings.getString(serverName + ".SQLDataSourceJNDIName");
        this.userTableName = settings.getString(serverName + ".SQLUserTableName");
        this.loginColumnName = settings.getString(serverName + ".SQLUserLoginColumnName");
        this.passwordColumnName = settings.getString(serverName + ".SQLUserPasswordColumnName");
        this.passwordAvailableColumnName = settings.getString(serverName + ".SQLUserPasswordAvailableColumnName");
    }

    protected AuthenticationConnection<Connection> openConnection() throws AuthenticationException {
        try {
            DataSource dataSource = (DataSource)InitialContext.doLookup(this.dataSourceJndiName);
            Connection connection = dataSource.getConnection();
            return new AuthenticationConnection<Connection>(connection);
        }
        catch (Exception iex) {
            throw new AuthenticationHostException("Connection failure with datasource " + this.dataSourceJndiName, (Throwable)iex);
        }
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        try {
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException("Cannot close the connection with datasource " + this.dataSourceJndiName, (Throwable)ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        String sqlPassword;
        String login = credential.getLogin();
        boolean loginIgnoreCase = credential.loginIgnoreCase();
        String password = credential.getPassword();
        if (password == null) {
            password = "";
        }
        if (!StringUtil.isDefined((String)(sqlPassword = this.getPassword(AuthenticationSQL.getSQLConnection(connection), login, loginIgnoreCase)))) {
            throw new AuthenticationBadCredentialException("Invalid credential for user with login: " + login, new String[0]);
        }
        this.checkPassword(login, password, sqlPassword);
        AuthenticationUserVerifierFactory.getUserMustChangePasswordVerifier(credential).verify();
    }

    private String getPassword(Connection connection, String login, boolean ignoreCase) throws AuthenticationException {
        String sqlPasswd;
        block16: {
            String loginQuery = StringUtil.isDefined((String)this.passwordAvailableColumnName) ? "SELECT " + this.loginColumnName + ", " + this.passwordColumnName + ", " + this.passwordAvailableColumnName + " FROM " + this.userTableName : "SELECT " + this.loginColumnName + ", " + this.passwordColumnName + " FROM " + this.userTableName;
            loginQuery = ignoreCase ? loginQuery + " WHERE lower(" + this.loginColumnName + ") = lower(?)" : loginQuery + " WHERE " + this.loginColumnName + " = ?";
            try (PreparedStatement stmt = connection.prepareStatement(loginQuery);){
                stmt.setString(1, login);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        String validString;
                        if (StringUtil.isDefined((String)this.passwordAvailableColumnName) && "N".equalsIgnoreCase(validString = rs.getString(this.passwordAvailableColumnName))) {
                            throw new AuthenticationPwdNotAvailException("Not password set for user with login: " + login, new String[0]);
                        }
                        sqlPasswd = rs.getString(this.passwordColumnName);
                        break block16;
                    }
                    throw new AuthenticationBadCredentialException("User not found with login: " + login, new String[0]);
                }
            }
            catch (SQLException ex) {
                throw new AuthenticationHostException((Throwable)ex);
            }
        }
        return sqlPasswd;
    }

    private void updatePassword(Connection connection, String login, boolean loginIgnoreCase, String newPassword) throws AuthenticationException {
        String updateQuery = "UPDATE " + this.userTableName + " SET " + this.passwordColumnName + " = ? WHERE ";
        updateQuery = loginIgnoreCase ? updateQuery + "lower(" + this.loginColumnName + ") = lower(?)" : updateQuery + this.loginColumnName + " = ?";
        try (PreparedStatement stmt = connection.prepareStatement(updateQuery);){
            stmt.setString(1, newPassword);
            stmt.setString(2, login);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new AuthenticationHostException((Throwable)ex);
        }
    }

    protected void doChangePassword(AuthenticationConnection connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        String login = credential.getLogin();
        String oldPassword = credential.getPassword();
        boolean loginIgnoreCase = credential.loginIgnoreCase();
        String passwordInDB = this.getPassword(sqlConnection, login, loginIgnoreCase);
        this.checkPassword(login, oldPassword, passwordInDB);
        String newPasswordInDB = this.getNewPasswordDigest(newPassword);
        this.updatePassword(sqlConnection, login, loginIgnoreCase, newPasswordInDB);
    }

    protected void doResetPassword(AuthenticationConnection connection, String login, boolean loginIgnoreCase, String newPassword) throws AuthenticationException {
        Connection sqlConnection = AuthenticationSQL.getSQLConnection(connection);
        String newPasswordInDB = this.getNewPasswordDigest(newPassword);
        this.updatePassword(sqlConnection, login, loginIgnoreCase, newPasswordInDB);
    }

    protected static Connection getSQLConnection(AuthenticationConnection<Connection> connection) {
        return connection.getConnector();
    }

    private String getNewPasswordDigest(String newPassword) {
        PasswordEncryption encryption = PasswordEncryptionProvider.getDefaultPasswordEncryption();
        return encryption.encrypt(newPassword);
    }

    private void checkPassword(String login, String password, String digest) throws AuthenticationBadCredentialException {
        block2: {
            try {
                PasswordEncryption encryption = PasswordEncryptionProvider.getPasswordEncryption(digest);
                encryption.check(password, digest);
            }
            catch (AssertionError error) {
                String actualDigest = CryptMD5.encrypt(password);
                if (actualDigest.equals(digest)) break block2;
                throw new AuthenticationBadCredentialException("Invalid credential for user with login: " + login, new String[0]);
            }
        }
    }
}

