/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.process.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Named;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.process.ProcessProvider;
import org.silverpeas.core.process.annotation.SimulationElementConversionProcess;
import org.silverpeas.core.process.annotation.SimulationElementLister;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.Process;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Bean
@Named
public class SimulationActionProcessProcessor {
    static final String SIMULATION_PROCESS_PERFORMED = "@SIMULATION_PROCESS_PERFORMED@";
    static final String SIMULATION_PROCESS_PROCESSING = "@SIMULATION_PROCESS_PROCESSING@";
    private final List<Context> contexts = new ArrayList<Context>();
    private TargetSupplier targetSupplier;
    private Supplier<String> language;
    private Method caller;

    protected SimulationActionProcessProcessor() {
    }

    public static SimulationActionProcessProcessor get() {
        return (SimulationActionProcessProcessor)ServiceProvider.getService(SimulationActionProcessProcessor.class, (Annotation[])new Annotation[0]);
    }

    public boolean isSimulationProcessPerforming() {
        return CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)SIMULATION_PROCESS_PROCESSING) != null;
    }

    public SourceSupplier withContext(Consumer<SourceSupplier.Sources> consumer) {
        return this.andWithContext(consumer);
    }

    SourceSupplier andWithContext(Consumer<SourceSupplier.Sources> consumer) {
        Context context = new Context(this);
        this.contexts.add(context);
        return context.set(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Process<T> process) {
        if (CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)SIMULATION_PROCESS_PERFORMED) == null) {
            try {
                CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)SIMULATION_PROCESS_PROCESSING, (Object)true);
                try {
                    for (Context context : this.contexts) {
                        this.simulate(context);
                    }
                }
                finally {
                    CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)SIMULATION_PROCESS_PROCESSING);
                }
                Object object = process.execute();
                return (T)object;
            }
            catch (Exception e) {
                Optional.ofNullable(this.caller).map(c -> "Error in intercepted method: " + c.getName()).ifPresent(m -> SilverLogger.getLogger((Object)this).error(m, (Throwable)e));
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            finally {
                CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)SIMULATION_PROCESS_PERFORMED);
            }
        }
        try {
            return (T)process.execute();
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    private void simulate(Context context) throws Exception {
        List<ResourceReference> sourcePKs = context.sourceSupplier.getSources().sourcePKs;
        List<ResourceReference> targetPKs = this.targetSupplier.getTargets().targetPKs;
        List<Object> sourceObjects = context.sourceSupplier.getSources().sourceObjects;
        if (!(sourcePKs.isEmpty() && sourceObjects.isEmpty() || targetPKs.isEmpty())) {
            String uiLanguage = this.getLanguage();
            HashMap elements = new HashMap();
            for (ResourceReference targetPK : targetPKs) {
                ActionType actionType = context.action.type.get();
                SimulationElementLister elementLister = context.lister.supplier.get();
                elementLister.setActionType(actionType);
                elementLister.setElements(elements);
                sourcePKs.stream().filter(sourcePK -> ActionType.MOVE != actionType || !sourcePK.getInstanceId().equals(targetPK.getInstanceId())).forEach(sourcePK -> elementLister.listElements((ResourceReference)sourcePK, uiLanguage));
                sourceObjects.forEach(sourceObject -> elementLister.listElements(sourceObject, uiLanguage, targetPK));
                ProcessProvider.getProcessManagement().execute(new SimulationElementConversionProcess(elements, targetPK, actionType), new ProcessExecutionContext(targetPK.getInstanceId()));
                CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)SIMULATION_PROCESS_PERFORMED, (Object)true);
            }
        } else {
            Optional.ofNullable(this.caller).map(c -> MessageFormat.format("Intercepted method ''{0}'', but SourcePK, SourceObject or TargetPK annotations are missing on parameter specifications...", c.getName())).ifPresent(m -> SilverLogger.getLogger((Object)this).warn(m, new Object[0]));
        }
    }

    private String getLanguage() {
        return Optional.ofNullable(this.language.get()).filter(StringUtil::isDefined).orElseGet(() -> Optional.ofNullable(User.getCurrentRequester()).map(User::getUserPreferences).map(UserPreferences::getLanguage).orElseGet(DisplayI18NHelper::getDefaultLanguage));
    }

    public SimulationActionProcessProcessor setLanguage(Supplier<String> language) {
        this.language = language;
        return this;
    }

    public SimulationActionProcessProcessor fromMethod(Method caller) {
        this.caller = caller;
        return this;
    }

    public static class Action {
        private final Context context;
        private Supplier<ActionType> type;

        private Action(Context context) {
            this.context = context;
        }

        Action set(Supplier<ActionType> actionType) {
            this.type = actionType;
            return this;
        }

        public SourceSupplier andWithContext(Consumer<SourceSupplier.Sources> consumer) {
            Context newContext = new Context(this.context.process);
            this.context.process.contexts.add(newContext);
            return newContext.set(consumer);
        }

        public SimulationActionProcessProcessor toTargets(Consumer<TargetSupplier.Targets> consumer) {
            this.context.process.targetSupplier = new TargetSupplier(consumer);
            return this.context.process;
        }
    }

    public static class TargetSupplier {
        private final Consumer<Targets> consumer;
        final MemoizedSupplier<Targets> targetCache = new MemoizedSupplier(() -> {
            Targets targets = new Targets();
            this.getConsumer().accept(targets);
            return targets;
        });

        private TargetSupplier(Consumer<Targets> consumer) {
            this.consumer = consumer;
        }

        private Consumer<Targets> getConsumer() {
            return this.consumer;
        }

        private Targets getTargets() {
            return (Targets)this.targetCache.get();
        }

        public static class Targets {
            private final List<ResourceReference> targetPKs = new ArrayList<ResourceReference>();

            public List<ResourceReference> getTargetPKs() {
                return this.targetPKs;
            }
        }
    }

    public static class Lister {
        private final Context context;
        private Supplier<SimulationElementLister> supplier;

        private Lister(Context context) {
            this.context = context;
        }

        private Lister set(Supplier<SimulationElementLister> supplier) {
            this.supplier = supplier;
            return this;
        }

        public Action byAction(Supplier<ActionType> actionType) {
            this.context.action = new Action(this.context);
            return this.context.action.set(actionType);
        }
    }

    public static class SourceSupplier {
        private final Context context;
        private final Consumer<Sources> consumer;
        private final MemoizedSupplier<Sources> sourceCache = new MemoizedSupplier(() -> {
            Sources sources = new Sources();
            this.getConsumer().accept(sources);
            return sources;
        });

        private SourceSupplier(Context context, Consumer<Sources> consumer) {
            this.context = context;
            this.consumer = consumer;
        }

        private Consumer<Sources> getConsumer() {
            return this.consumer;
        }

        private Sources getSources() {
            return (Sources)this.sourceCache.get();
        }

        public Lister listElementsWith(Supplier<SimulationElementLister> supplier) {
            this.context.lister = new Lister(this.context);
            return this.context.lister.set(supplier);
        }

        public static class Sources {
            private final List<Object> sourceObjects = new ArrayList<Object>();
            private final List<ResourceReference> sourcePKs = new ArrayList<ResourceReference>();

            public List<Object> getSourceObjects() {
                return this.sourceObjects;
            }

            public List<ResourceReference> getSourcePKs() {
                return this.sourcePKs;
            }
        }
    }

    public static class Context {
        private final SimulationActionProcessProcessor process;
        private SourceSupplier sourceSupplier;
        private Lister lister;
        private Action action;

        private Context(SimulationActionProcessProcessor process) {
            this.process = process;
        }

        SourceSupplier set(Consumer<SourceSupplier.Sources> sources) {
            this.sourceSupplier = new SourceSupplier(this, sources);
            return this.sourceSupplier;
        }
    }
}

