/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.delayed.repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.delayed.constant.DelayedNotificationFrequency;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationData;
import org.silverpeas.core.notification.user.delayed.repository.DelayedNotificationDataRepository;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;

@Repository
public class DelayedNotificationDataJpaRepository
extends BasicJpaEntityRepository<DelayedNotificationData>
implements DelayedNotificationDataRepository {
    private static final String CHANNELS = "channels";

    @Override
    public List<Integer> findAllUsersToBeNotified(Collection<Integer> aimedChannels) {
        return this.listFromNamedQuery("DelayedNotificationData.findDistinctUserByChannel", this.newNamedParameters().add(CHANNELS, aimedChannels), Integer.class);
    }

    @Override
    public List<DelayedNotificationData> findByUserId(int userId, Collection<Integer> aimedChannels) {
        return this.listFromNamedQuery("DelayedNotificationData.findByUserId", this.newNamedParameters().add("userId", (Object)userId).add(CHANNELS, aimedChannels));
    }

    @Override
    public long deleteByIds(Collection<Long> ids) {
        return this.deleteFromNamedQuery("DelayedNotificationData.deleteByIds", this.newNamedParameters().add("ids", (Object)UniqueLongIdentifier.fromLongs(ids)));
    }

    @Override
    public List<Integer> findUsersToBeNotified(Set<NotifChannel> aimedChannels, Set<DelayedNotificationFrequency> aimedFrequencies, boolean isThatUsersWithNoSettingHaveToBeNotified) {
        NamedParameters namedParameters = this.newNamedParameters();
        StringBuilder query = new StringBuilder();
        query.append("select distinct d.userId from DelayedNotificationData d ");
        query.append("left outer join DelayedNotificationUserSetting p on ");
        query.append("  d.userId = p.userId and d.channel = p.channel ");
        query.append("where d.channel in (:");
        query.append(namedParameters.add(CHANNELS, (Object)NotifChannel.toIds(aimedChannels)).getLastParameterName());
        query.append(") and ( ");
        query.append("  (p.id is not null and p.frequency in (:");
        query.append(namedParameters.add("frequencies", (Object)DelayedNotificationFrequency.toCodes(aimedFrequencies)).getLastParameterName()).append(")) ");
        if (isThatUsersWithNoSettingHaveToBeNotified) {
            query.append("  or p.id is null ");
        }
        query.append(") ");
        return this.listFromJpqlString(query.toString(), namedParameters, Integer.class);
    }

    @Override
    public List<DelayedNotificationData> findDelayedNotification(DelayedNotificationData delayedNotification) {
        NamedParameters namedParameters = this.newNamedParameters();
        StringBuilder query = new StringBuilder("select d from DelayedNotificationData d where");
        query.append(" d.userId = :").append(namedParameters.add("userId", (Object)delayedNotification.getUserId()).getLastParameterName());
        query.append(" and d.fromUserId = :").append(namedParameters.add("fromUserId", (Object)delayedNotification.getFromUserId()).getLastParameterName());
        query.append(" and d.channel = :").append(namedParameters.add("channel", (Object)delayedNotification.getChannel().getId()).getLastParameterName());
        query.append(" and d.action = :").append(namedParameters.add("action", (Object)delayedNotification.getAction().getId()).getLastParameterName());
        query.append(" and d.language = :").append(namedParameters.add("language", (Object)delayedNotification.getLanguage()).getLastParameterName());
        Date date = delayedNotification.getCreationDate() == null ? new Date() : delayedNotification.getCreationDate();
        query.append(" and d.creationDate between :").append(namedParameters.add("creationDateMin", (Object)DateUtils.addSeconds((Date)date, (int)-45), TemporalType.TIMESTAMP).getLastParameterName()).append(" and :").append(namedParameters.add("creationDateMax", (Object)DateUtils.addSeconds((Date)date, (int)45), TemporalType.TIMESTAMP).getLastParameterName());
        query.append(" and d.resource = :").append(namedParameters.add("resourceId", (Object)delayedNotification.getResource()).getLastParameterName());
        if (StringUtils.isNotBlank((CharSequence)delayedNotification.getMessage())) {
            query.append(" and d.message = :").append(namedParameters.add("message", (Object)delayedNotification.getMessage()).getLastParameterName());
        } else {
            query.append(" and d.message is null");
        }
        return this.listFromJpqlString(query.toString(), namedParameters, DelayedNotificationData.class);
    }
}

