/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.IPTC;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.memory.MemoryData;
import org.silverpeas.core.util.time.Duration;
import org.silverpeas.kernel.util.StringUtil;

public class MetaData {
    private final Metadata tikaMetadata;

    MetaData(Metadata metadata) {
        this.tikaMetadata = metadata;
    }

    public String getValue(String name) {
        return this.tikaMetadata.get(name);
    }

    public List<String> getAvailablePropertyNames() {
        return Arrays.asList(this.tikaMetadata.names());
    }

    public String getTitle() {
        return this.cleanString(this.tikaMetadata.get(TikaCoreProperties.TITLE));
    }

    public String getContentType() {
        String contentType = this.tikaMetadata.get("Content-Type");
        if (StringUtil.isNotDefined((String)contentType)) {
            contentType = this.tikaMetadata.get(TikaCoreProperties.FORMAT);
        }
        return contentType;
    }

    public String getSubject() {
        String subject = "";
        ArrayList<String> subjectAndKeywords = new ArrayList<String>(Arrays.asList(this.cleanString(this.tikaMetadata.getValues(TikaCoreProperties.SUBJECT))));
        List<String> keywords = Arrays.asList(this.getKeywords());
        subjectAndKeywords.removeAll(keywords);
        if (!subjectAndKeywords.isEmpty()) {
            subject = String.join((CharSequence)", ", subjectAndKeywords);
        }
        if (StringUtil.isNotDefined((String)subject)) {
            Property ooXmlSubject = Property.composite((Property)Property.externalText((String)"cp:subject"), (Property[])new Property[]{DublinCore.SUBJECT});
            subject = this.tikaMetadata.get(ooXmlSubject);
        }
        if (StringUtil.isNotDefined((String)subject)) {
            subject = String.join((CharSequence)". ", keywords);
        }
        return this.cleanString(subject);
    }

    public String getAuthor() {
        String author = this.tikaMetadata.get(TikaCoreProperties.CREATOR);
        if (StringUtil.isNotDefined((String)author)) {
            author = this.tikaMetadata.get(Office.AUTHOR);
        }
        return this.cleanString(author);
    }

    public String getLastAuthor() {
        String[] authors = this.tikaMetadata.getValues(TikaCoreProperties.CREATOR);
        if (authors.length > 1) {
            return authors[authors.length - 1];
        }
        return this.cleanString(this.tikaMetadata.get(TikaCoreProperties.MODIFIER));
    }

    public String getComments() {
        String comments = this.tikaMetadata.get(TikaCoreProperties.COMMENTS);
        if (StringUtil.isNotDefined((String)comments)) {
            comments = this.tikaMetadata.get(TikaCoreProperties.DESCRIPTION);
        }
        return this.cleanString(comments);
    }

    public String[] getKeywords() {
        return this.cleanString(this.tikaMetadata.getValues(Office.KEYWORDS));
    }

    public String getSilverId() {
        return this.cleanString(this.tikaMetadata.get("SILVERID"));
    }

    public String getSilverName() {
        return this.tikaMetadata.get("SILVERNAME");
    }

    public Date getLastSaveDateTime() {
        Date date = this.parseDate(TikaCoreProperties.MODIFIED);
        if (date == null) {
            return this.parseDate(Office.SAVE_DATE);
        }
        return date;
    }

    public Date getCreationDate() {
        Date result = this.getDate(TikaCoreProperties.CREATED);
        if (result == null) {
            result = this.tikaMetadata.getDate(TikaCoreProperties.CREATED);
        }
        if (result == null) {
            result = this.tikaMetadata.getDate(Office.CREATION_DATE);
        }
        return result;
    }

    public Definition getDefinition() {
        Definition definition = Definition.fromZero();
        Integer result = this.getInteger(TIFF.IMAGE_WIDTH);
        if (result == null) {
            result = this.getInteger(FLV.WIDTH);
        }
        if (result == null) {
            result = this.getInteger(IPTC.MAX_AVAIL_WIDTH);
        }
        if (result != null) {
            definition.widthOf(result);
        }
        if ((result = this.getInteger(TIFF.IMAGE_LENGTH)) == null) {
            result = this.getInteger(FLV.HEIGHT);
        }
        if (result == null) {
            result = this.getInteger(IPTC.MAX_AVAIL_HEIGHT);
        }
        if (result != null) {
            definition.heightOf(result);
        }
        return definition;
    }

    public BigDecimal getFramerate() {
        BigDecimal result = this.getBigDecimal(XMPDM.VIDEO_FRAME_RATE);
        if (result == null) {
            result = this.getBigDecimal(FLV.FRAMERATE);
        }
        return result;
    }

    public Duration getDuration() {
        Duration result = null;
        BigDecimal duration = this.getBigDecimal(XMPDM.DURATION);
        if (duration != null) {
            result = UnitUtil.getDuration((BigDecimal)duration);
        }
        if (result == null && (duration = this.getBigDecimal(FLV.DURATION)) != null) {
            result = UnitUtil.getDuration((BigDecimal)duration, (TimeUnit)TimeUnit.SECOND);
        }
        return result;
    }

    public MemoryData getMemoryData() {
        Long result = this.getLong("Content-Length");
        return result != null ? UnitUtil.getMemData((long)result) : null;
    }

    private Date getDate(Property property) {
        Date result = this.tikaMetadata.getDate(property);
        if (result == null) {
            return this.parseDate(property);
        }
        return result;
    }

    private Integer getInteger(Property property) {
        BigDecimal value;
        Integer result = this.tikaMetadata.getInt(property);
        if (result == null && (value = this.getBigDecimal(property)) != null) {
            result = value.intValue();
        }
        return result;
    }

    private Long getLong(String propertyName) {
        String result = this.cleanString(this.tikaMetadata.get(propertyName));
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BigDecimal getBigDecimal(Property property) {
        String result = this.cleanString(this.tikaMetadata.get(property));
        try {
            return new BigDecimal(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Date parseDate(Property property) {
        String date = this.tikaMetadata.get(property);
        if (date != null) {
            try {
                return DateUtil.parse((String)date, (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }

    private String[] cleanString(String[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.cleanString(values[i]);
        }
        if (result.length > 1) {
            LinkedHashSet uniqueResult = new LinkedHashSet();
            Collections.addAll(uniqueResult, result);
            return uniqueResult.toArray(new String[0]);
        }
        return result;
    }

    private String cleanString(String value) {
        if (StringUtil.isDefined((String)value)) {
            return value.replace("\u0000", "").replace("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd", "").trim();
        }
        return value;
    }

    private static class FLV {
        public static final Property WIDTH = Property.internalText((String)"width");
        public static final Property HEIGHT = Property.internalText((String)"height");
        public static final Property DURATION = Property.internalText((String)"duration");
        public static final Property FRAMERATE = Property.internalText((String)"framerate");

        private FLV() {
        }
    }
}

