/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.silverpeas.kernel.util.StringUtil;

public final class IndexEntryKey
implements Serializable {
    private static final long serialVersionUID = 339617003068469338L;
    private static final String SEP = "|";
    private final String component;
    private final String objectType;
    private final String objectId;
    private final String linkedObjectId;

    public IndexEntryKey(String componentId, String objectType, String objectId) {
        this.component = this.normalize(componentId);
        this.objectType = this.normalize(objectType);
        this.objectId = this.normalize(objectId);
        this.linkedObjectId = "";
    }

    public IndexEntryKey(String componentId, String objectType, String objectId, String linkedObjectId) {
        this.component = this.normalize(componentId);
        this.objectType = this.normalize(objectType);
        this.objectId = this.normalize(objectId);
        this.linkedObjectId = this.normalize(linkedObjectId);
    }

    IndexEntryKey(IndexEntryKey other) {
        this.component = other.component;
        this.objectType = other.objectType;
        this.objectId = other.objectId;
        this.linkedObjectId = other.linkedObjectId;
    }

    public static IndexEntryKey create(String s) {
        StringTokenizer stk = new StringTokenizer(s, SEP, true);
        String[] keyParts = new String[]{"", "", "", ""};
        for (int i = 0; stk.hasMoreElements() && i < 4; ++i) {
            String token = stk.nextToken();
            if (token.equals(SEP)) continue;
            keyParts[i] = token;
            if (!stk.hasMoreElements()) continue;
            stk.nextToken();
        }
        return new IndexEntryKey(keyParts[0], keyParts[1], keyParts[2], keyParts[3]);
    }

    public String getComponentId() {
        return this.component;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getLinkedObjectId() {
        return this.linkedObjectId;
    }

    public String toString() {
        return this.getComponentId() + SEP + this.getObjectType() + SEP + this.getObjectId() + SEP + this.getLinkedObjectId();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexEntryKey) {
            IndexEntryKey k = (IndexEntryKey)o;
            return this.toString().equals(k.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private String normalize(String raw) {
        return StringUtil.defaultStringIfNotDefined((String)raw);
    }
}

