/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.indexing.model.FileDescription;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.index.indexing.model.TextDescription;
import org.silverpeas.kernel.util.StringUtil;

public class FullIndexEntry
extends IndexEntry
implements Serializable {
    private static final long serialVersionUID = -4955524385769457730L;
    private List<TextDescription> textList = null;
    private List<FileDescription> fileList = null;
    private List<FileDescription> linkedFileList = null;
    private List<FieldDescription> fields = null;
    private Set<String> linkedFileIdsList = null;

    public FullIndexEntry(IndexEntryKey pk) {
        super(pk);
    }

    FullIndexEntry(FullIndexEntry other) {
        super(other);
        this.textList = other.textList != null ? new ArrayList<TextDescription>(other.textList) : null;
        this.fileList = other.fileList != null ? new ArrayList<FileDescription>(other.fileList) : null;
        this.linkedFileList = other.linkedFileList != null ? new ArrayList<FileDescription>(other.linkedFileList) : null;
        this.fields = other.fields != null ? new ArrayList<FieldDescription>(other.fields) : null;
        this.linkedFileIdsList = other.linkedFileIdsList != null ? new HashSet<String>(other.linkedFileIdsList) : null;
    }

    public void addTextContent(String text) {
        this.addTextContent(text, null);
    }

    public void addTextContent(String text, String language) {
        if (StringUtil.isDefined((String)text)) {
            this.getTextList().add(new TextDescription(text, language));
        }
    }

    public void addFileContent(String path, String encoding, String format, String lang) {
        if (path != null) {
            FileDescription fd = new FileDescription(path, encoding, format, lang);
            if (!this.getFileList().contains(fd)) {
                this.getFileList().add(fd);
            }
        }
    }

    public void addLinkedFileId(String fileId) {
        this.getLinkedFileIdsSet().add(fileId);
    }

    public void addLinkedFileContent(String path, String encoding, String format, String lang) {
        if (path != null) {
            this.getLinkedFileList().add(new FileDescription(path, encoding, format, lang));
        }
    }

    public void addField(String fieldName, String value) {
        this.addField(fieldName, value, null, false);
    }

    public void addField(String fieldName, String value, String language, boolean stored) {
        this.getFields().add(new FieldDescription(fieldName, value, language, stored));
    }

    public void addField(String fieldName, Date value) {
        this.addField(fieldName, value, null);
    }

    public void addField(String fieldName, Date value, String language) {
        this.getFields().add(new FieldDescription(fieldName, value, language, false));
    }

    public List<TextDescription> getTextContentList() {
        return this.getTextList();
    }

    public List<FileDescription> getFileContentList() {
        return this.getFileList();
    }

    public List<FileDescription> getLinkedFileContentList() {
        return this.getLinkedFileList();
    }

    private List<TextDescription> getTextList() {
        if (this.textList == null) {
            this.textList = new ArrayList<TextDescription>();
        }
        return this.textList;
    }

    private List<FileDescription> getFileList() {
        if (this.fileList == null) {
            this.fileList = new ArrayList<FileDescription>();
        }
        return this.fileList;
    }

    private List<FileDescription> getLinkedFileList() {
        if (this.linkedFileList == null) {
            this.linkedFileList = new ArrayList<FileDescription>();
        }
        return this.linkedFileList;
    }

    public Set<String> getLinkedFileIdsSet() {
        if (this.linkedFileIdsList == null) {
            this.linkedFileIdsList = new HashSet<String>();
        }
        return this.linkedFileIdsList;
    }

    public List<FieldDescription> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDescription>();
        }
        return this.fields;
    }

    public FullIndexEntry getCopy() {
        return new FullIndexEntry(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

