/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.util;

import org.silverpeas.core.ActionType;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.subscription.SubscriptionResource;

public class ContributionManagementContext {
    private final ContributionIdentifier contributionId;
    private SubscriptionResource linkedSubscriptionResource;
    private Location location;
    private ActionType entityPersistenceAction = ActionType.READ;
    private ContributionStatus entityStatusBeforePersistAction = ContributionStatus.UNKNOWN;
    private ContributionStatus entityStatusAfterPersistAction = ContributionStatus.UNKNOWN;

    public static ContributionManagementContext atComponentInstanceId(String id) {
        return new ContributionManagementContext(ContributionIdentifier.from((String)id, (String)id, (String)"UNKNOWN"));
    }

    public static ContributionManagementContext on(Contribution contribution) {
        return new ContributionManagementContext(contribution.getIdentifier());
    }

    private ContributionManagementContext(ContributionIdentifier contributionId) {
        this.contributionId = contributionId;
    }

    public ContributionManagementContext aboutSubscriptionResource(SubscriptionResource linkedSubscriptionResource) {
        this.linkedSubscriptionResource = linkedSubscriptionResource;
        return this;
    }

    public ContributionManagementContext atLocation(Location location) {
        this.location = location;
        return this;
    }

    public ContributionIdentifier getContributionId() {
        return this.contributionId;
    }

    public SubscriptionResource getLinkedSubscriptionResource() {
        return this.linkedSubscriptionResource;
    }

    public ContributionManagementContext forPersistenceAction(ContributionStatus entityStatusBeforePersistenceAction, ActionType entityPersistenceAction, ContributionStatus entityStatusAfterPersistenceAction) {
        this.entityStatusBeforePersistAction = entityStatusBeforePersistenceAction;
        this.entityPersistenceAction = entityPersistenceAction;
        this.entityStatusAfterPersistAction = entityStatusAfterPersistenceAction;
        return this;
    }

    public ActionType getEntityPersistenceAction() {
        return this.entityPersistenceAction;
    }

    public ContributionStatus getEntityStatusBeforePersistAction() {
        return this.entityStatusBeforePersistAction;
    }

    public ContributionStatus getEntityStatusAfterPersistAction() {
        return this.entityStatusAfterPersistAction;
    }

    public Location getLocation() {
        return this.location;
    }
}

