/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.contentcontainer.content;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContentI18N;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.DateUtil;

public class GlobalSilverContent
extends AbstractI18NBean<GlobalSilverContentI18N>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url = "";
    private String location = "";
    private String id = "";
    private String instanceId = "";
    private final Date updateDate;
    private final Date creationDate;
    private String thumbnailURL = "";
    private String userId = "";
    private String type = "";
    private Map<String, String> sortableXMLFormFields = null;
    private String spaceId = "";

    @Override
    protected Class<GlobalSilverContentI18N> getTranslationType() {
        return GlobalSilverContentI18N.class;
    }

    private void init(String name, String desc, String id, String instanceId, String userId) {
        this.setName(name);
        this.setDescription(desc);
        this.id = id;
        this.instanceId = instanceId;
        this.userId = userId;
        GlobalSilverContentI18N gscI18N = new GlobalSilverContentI18N(I18NHelper.DEFAULT_LANGUAGE, name, desc);
        this.addTranslation(gscI18N);
    }

    public GlobalSilverContent(SilverContentInterface sci) {
        Date date;
        try {
            date = sci.getDate() == null ? null : DateUtil.parseDate((String)sci.getDate());
        }
        catch (ParseException e) {
            date = null;
        }
        this.init(sci.getName(), sci.getDescription(), sci.getId(), sci.getInstanceId(), sci.getCreatorId());
        this.updateDate = date;
        this.creationDate = sci.getCreationDate();
        this.type = sci.getContributionType();
        this.processLanguages(sci);
    }

    private void processLanguages(SilverContentInterface sci) {
        Collection<String> languages = sci.getLanguages();
        languages.forEach(l -> {
            GlobalSilverContentI18N gscI18N = new GlobalSilverContentI18N((String)l, sci.getName((String)l), sci.getDescription((String)l));
            this.addTranslation(gscI18N);
        });
    }

    public String getURL() {
        return this.url;
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getTitle() {
        return this.getName();
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getThumbnailURL() {
        return this.thumbnailURL;
    }

    public void setThumbnailURL(String thumbnailURL) {
        this.thumbnailURL = thumbnailURL;
    }

    public Map<String, String> getSortableXMLFormFields() {
        return this.sortableXMLFormFields;
    }
}

