/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.text.MessageFormat;
import java.util.Random;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.ElementAttributes;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.html.SupportedWebPlugin;
import org.silverpeas.core.html.WebPlugin;
import org.silverpeas.core.ui.DisplayI18NHelper;

public class VideoPlayer {
    private static final int DEFAULT_WIDTH = 425;
    private static final int DEFAULT_HEIGHT = 300;
    private static final Random RANDOM_GENERATOR = new Random();
    private static final String TEMPLATE_SCRIPT = "jQuery(document).ready(function() '{'jQuery(''{0}'').embedPlayer('{'url : ''{1}'',width : {2}, height : {3},playerParameters : '{'posterUrl : ''{4}'',mimeType : ''{5}'',autoPlay : {6},backgroundColor : ''{7}'' '}' '}');'}')";
    private String videoURL = "";
    private String posterURL = "";
    private String mimeType = "";
    private boolean autoplay = false;
    private int width = 425;
    private int height = 300;
    private String backgroundColor = "";

    public VideoPlayer(String videoURL, boolean autoplay) {
        this.videoURL = videoURL;
        this.autoplay = autoplay;
    }

    public VideoPlayer() {
    }

    public boolean isAutoplay() {
        return this.autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public String getVideoURL() {
        return this.videoURL;
    }

    public void setVideoURL(String videoURL) {
        this.videoURL = videoURL == null ? "" : videoURL;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getPosterURL() {
        return this.posterURL;
    }

    public void setPosterURL(String posterURL) {
        this.posterURL = posterURL;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    private String generateId() {
        return "video-player" + RANDOM_GENERATOR.nextInt();
    }

    public void init(ConcreteElement element) {
        this.include(element, (ElementAttributes)WebPlugin.get().getHtml(SupportedWebPlugin.Constants.EMBEDPLAYER, DisplayI18NHelper.getDefaultLanguage()));
    }

    public void renderIn(ConcreteElement element) {
        String videoId = this.generateId();
        if (!this.getVideoURL().isEmpty()) {
            div video = new div();
            video.setID(videoId);
            this.include(element, (ElementAttributes)video);
        }
        script player = new script(MessageFormat.format(TEMPLATE_SCRIPT, "#" + videoId, this.getVideoURL(), String.valueOf(this.getWidth()), String.valueOf(this.getHeight()), this.getPosterURL(), this.getMimeType(), this.isAutoplay(), this.getBackgroundColor())).setType("text/javascript");
        this.include(element, (ElementAttributes)player);
    }

    private void include(ConcreteElement xhtml, ElementAttributes inclusion) {
        if (xhtml instanceof ElementContainer) {
            ((ElementContainer)xhtml).addElement((Element)inclusion);
        } else {
            xhtml.addElementToRegistry((Element)inclusion);
        }
    }
}

