/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.GalleryHelper;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFileFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class ImageFieldDisplayer
extends AbstractFileFieldDisplayer {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");

    @Override
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SimpleDocumentPK attachmentPk;
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        String language = pageContext.getLanguage();
        AbstractFileFieldDisplayer.Operation originalOperation = AbstractFileFieldDisplayer.Operation.ADD;
        String componentId = pageContext.getComponentId();
        String attachmentId = field.getAttachmentId();
        if (StringUtil.isLong((String)attachmentId)) {
            attachmentPk = new SimpleDocumentPK(null, componentId);
            attachmentPk.setOldSilverpeasId(Long.parseLong(attachmentId));
        } else {
            attachmentPk = new SimpleDocumentPK(attachmentId, componentId);
        }
        Object imageURL = null;
        if (StringUtil.isDefined((String)attachmentId)) {
            if (attachmentId.startsWith("/")) {
                imageURL = attachmentId;
                originalOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
            } else {
                SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(attachmentPk, language);
                if (attachment != null) {
                    originalOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
                    imageURL = pageContext.isSharingContext() ? pageContext.getSharingContext().getSharedUriOf(attachment).toString() : URLUtil.getApplicationURL() + attachment.getAttachmentURL();
                }
            }
        } else {
            attachmentId = "";
        }
        Map<String, String> parameters = template.getParameters(language);
        if (!template.isHidden()) {
            if (template.isReadOnly()) {
                if (imageURL != null) {
                    this.displayImage(parameters, (String)imageURL, out, pageContext.isSharingContext());
                }
            } else if (!template.isDisabled()) {
                String displayCSS = "display:none";
                if (imageURL != null) {
                    displayCSS = "display:block";
                }
                String deleteImg = Util.getIcon("delete");
                String deleteLab = Util.getString("removeImage", language);
                String size = settings.getString("image.size.xmlform.thumbnail", null);
                if (!StringUtil.isDefined((String)size)) {
                    size = "x50";
                }
                Object thumbnailURL = imageURL;
                thumbnailURL = imageURL != null ? FileServerUtils.getImageURL((String)imageURL, size) : "/util/viewgenerator/icons/px.gif";
                out.println("<div id=\"" + fieldName + "ThumbnailArea\" class=\"thumbnailArea\" style=\"" + displayCSS + "\">");
                out.println("<a id=\"" + fieldName + "ThumbnailLink\" href=\"" + StringUtil.defaultStringIfNotDefined((String)imageURL, (String)"javascript:void(0)") + "\" target=\"_blank\">");
                out.println("<img alt=\"\" align=\"top\" src=\"" + (String)thumbnailURL + "\" id=\"" + fieldName + "Thumbnail\"/>&nbsp;");
                out.println("</a>");
                out.println("&nbsp;<a href=\"#\" onclick=\"javascript:document.getElementById('" + fieldName + "ThumbnailArea').style.display='none';document." + pageContext.getFormName() + "." + fieldName + "Operation.value='" + AbstractFileFieldDisplayer.Operation.DELETION.name() + "';return false;\">");
                out.println("<img src=\"" + deleteImg + "\" width=\"15\" height=\"15\" alt=\"" + deleteLab + "\" align=\"top\" title=\"" + deleteLab + "\"/></a>");
                out.println("</div>");
                out.println("<div id=\"" + fieldName + "SelectionArea\">");
                out.print("<input type=\"file\" size=\"50\" id=\"");
                out.print(fieldName);
                out.print("\" name=\"");
                out.print(fieldName);
                out.println("\"/>");
                out.println("<input type=\"hidden\" name=\"" + fieldName + "$$id\" id=\"" + fieldName + "_id\" value=\"" + attachmentId + "\"/>");
                out.println("<input type=\"hidden\" id=\"" + fieldName + "Operation\" name=\"" + fieldName + "Operation\" value=\"" + originalOperation.name() + "\"/>");
                boolean useGalleries = Util.getBooleanValue(parameters, "galleries");
                if (useGalleries) {
                    this.renderGalleries(originalOperation, fieldName, language, out);
                }
                if (template.isMandatory() && pageContext.useMandatory()) {
                    out.println(Util.getMandatorySnippet());
                }
                out.println("</div>");
            }
        }
    }

    private void displayImage(Map<String, String> parameters, String imageURL, PrintWriter out, boolean useOriginalDimension) {
        if (!useOriginalDimension) {
            String height = parameters.containsKey("height") ? parameters.get("height") : "";
            String width = parameters.containsKey("width") ? parameters.get("width") : "";
            Object size = width + "x" + height;
            if (((String)size).length() <= 1) {
                size = settings.getString("image.size.xmlform", null);
            }
            if (StringUtil.isDefined((String)size)) {
                imageURL = FileServerUtils.getImageURL(imageURL, (String)size);
            }
        }
        out.print("<img alt=\"\" src=\"");
        out.print(imageURL);
        out.print("\"");
        out.print("/>");
    }

    private void renderGalleries(AbstractFileFieldDisplayer.Operation originalOperation, String fieldName, String language, PrintWriter out) {
        String fieldNameFunction = FileServerUtils.replaceAccentChars(fieldName.replace(' ', '_'));
        List<ComponentInstLight> galleries = WysiwygController.getGalleries();
        if (CollectionUtil.isNotEmpty(galleries)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ").append(Util.getString("GML.or", language)).append(" ");
            if (galleries.size() > 1) {
                stringBuilder.append("<select id=\"galleryFile_").append(fieldName).append("\" name=\"galleryFile\" onchange=\"openGalleryFileManager").append(fieldNameFunction).append("();this.selectedIndex=0\">");
                stringBuilder.append("<option value=\"\">");
                stringBuilder.append(Util.getString("GML.thumbnail.galleries", language));
                stringBuilder.append("</option>");
                for (ComponentInstLight component : galleries) {
                    stringBuilder.append("<option value=\"").append(component.getId()).append("\">").append(component.getLabel(language)).append("</option>");
                }
                stringBuilder.append("</select>");
            } else {
                ComponentInstLight component = galleries.get(0);
                String title = Util.getString("GML.thumbnail.gallery.help", language);
                String label = Util.getString("GML.thumbnail.gallery", language);
                stringBuilder.append("<a href=\"#\" class=\"button-imageBank\" onclick=\"openGalleryFileManager").append(fieldNameFunction).append("('").append(component.getId()).append("')\" title=\"").append(title).append("\">").append(label).append("</a>");
            }
            out.println(stringBuilder.toString());
            out.println("<script type=\"text/javascript\">");
            GalleryHelper.getJavaScript(fieldNameFunction, fieldName, language, out);
            out.println("function choixImageInGallery" + fieldNameFunction + "(url){");
            out.println("$(\"#" + fieldName + "ThumbnailArea\").css(\"display\", \"block\");");
            out.println("$(\"#" + fieldName + "Thumbnail\").attr(\"src\", url);");
            out.println("$(\"#" + fieldName + "ThumbnailLink\").attr(\"href\", url);");
            out.println("$(\"#" + fieldName + "_id\").attr(\"value\", url);");
            out.println("$(\"#" + fieldName + "Operation\").attr(\"value\", \"" + originalOperation.name() + "\");");
            out.println("}");
            out.println("</script>");
        }
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }
}

