/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractTextFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.kernel.util.StringUtil;

public class EmailFieldDisplayer
extends AbstractTextFieldDisplayer {
    public static final String PARAM_MAILTO = "mailto";
    public static final String PARAM_SIZE = "size";

    @Override
    public void addSpecificScript(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
        String language = pageContext.getLanguage();
        String label = template.getLabel(language);
        if (template.isMandatory() && pageContext.useMandatory()) {
            String script2 = "   if (!checkemail(field.value)) {\n     errorMsg+=\"  - '" + label + "' " + Util.getString("GML.MustContainsEmail", language) + "\\n\";\n     errorNb++;\n   }\n";
            out.print(script2);
        }
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        AbstractTextFieldDisplayer.FieldProperties fieldProps = this.getFieldProperties(template, field, pageContext);
        if (template.isReadOnly() && !template.isHidden()) {
            if (StringUtil.isDefined((String)fieldProps.getValue())) {
                if (StringUtil.getBooleanValue((String)fieldProps.getParameters().get(PARAM_MAILTO))) {
                    a mailto = new a();
                    mailto.setHref("mailto:" + fieldProps.getValue());
                    mailto.addElement(fieldProps.getValue());
                    out.println(mailto);
                } else {
                    out.println(fieldProps.getValue());
                }
            }
        } else {
            input inputField = new input();
            inputField.setName(fieldProps.getFieldName());
            inputField.setID(fieldProps.getFieldName());
            inputField.setValue(fieldProps.getValue());
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength(100);
            inputField.setSize(fieldProps.getParameters().getOrDefault(PARAM_SIZE, "50"));
            if (fieldProps.getParameters().containsKey("border")) {
                inputField.setBorder(Integer.parseInt(fieldProps.getParameters().get("border")));
            }
            Printable elt = EmailFieldDisplayer.initInputField(template, inputField, pageContext);
            out.println(elt);
        }
    }
}

