/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.util;

import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SharingContext
implements Serializable {
    private static final Pattern REGEXPR_SHARED_ATTACHMENT = Pattern.compile("(?i)src=\"(.+/attachmentId/[^\"]+)");
    private String baseURI;
    private String token;

    public SharingContext(String baseURI, String token) {
        this.baseURI = baseURI;
        this.token = token;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String applyOn(String text) {
        Matcher matcher;
        String newStr = text;
        while ((matcher = REGEXPR_SHARED_ATTACHMENT.matcher(newStr)).find()) {
            String currentURL = matcher.group(1);
            newStr = matcher.replaceFirst("src=\"" + this.convertURLToSharedOne(currentURL));
        }
        return newStr;
    }

    private String convertURLToSharedOne(String url) {
        Object[] parts = StringUtil.split((String)url, (String)"/");
        Object name = parts[ArrayUtil.indexOf(parts, "name") + 1];
        Object id = parts[ArrayUtil.indexOf(parts, "attachmentId") + 1];
        Object instanceId = parts[ArrayUtil.indexOf(parts, "componentId") + 1];
        return UriBuilder.fromUri((String)this.getBaseURI()).path("sharing/attachments").path((String)instanceId).path(this.getToken()).path((String)id).path((String)name).build(new Object[0]).toString();
    }

    public URI getSharedUriOf(SimpleDocument attachment) {
        URI sharedUri;
        try {
            sharedUri = UriBuilder.fromUri((String)this.getBaseURI()).path("sharing/attachments").path(attachment.getInstanceId()).path(this.getToken()).path(attachment.getId()).path(URLEncoder.encode(attachment.getFilename(), StandardCharsets.UTF_8.name())).build(new Object[0]);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        return sharedUri;
    }
}

