/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.subscription;

import java.util.Collection;
import java.util.HashSet;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.subscription.CalendarSubscription;
import org.silverpeas.core.calendar.subscription.CalendarSubscriptionConstants;
import org.silverpeas.core.calendar.subscription.CalendarSubscriptionResource;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.AbstractResourceSubscriptionService;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;

public abstract class AbstractCalendarSubscriptionService
extends AbstractResourceSubscriptionService {
    @Override
    public void init() {
        super.init();
        SubscriptionFactory.get().register(CalendarSubscriptionConstants.CALENDAR, (r, s, i) -> new CalendarSubscriptionResource(new ResourceReference(r, i)), (s, r, c) -> new CalendarSubscription(s, (CalendarSubscriptionResource)r, c));
    }

    @Override
    public SubscriptionSubscriberList getSubscribersOfComponentAndTypedResource(String componentInstanceId, SubscriptionResourceType resourceType, String resourceId, SubscriberDirective ... directives) {
        HashSet<SubscriptionSubscriber> subscribers = new HashSet<SubscriptionSubscriber>();
        SubscriptionResourceType nextTypeToHandle = resourceType;
        if (nextTypeToHandle == CalendarSubscriptionConstants.CALENDAR) {
            this.verifyCalendar(componentInstanceId, resourceId, subscribers);
            nextTypeToHandle = CommonSubscriptionResourceConstants.COMPONENT;
        }
        if (nextTypeToHandle == CommonSubscriptionResourceConstants.COMPONENT) {
            subscribers.addAll(super.getSubscribersOfComponentAndTypedResource(componentInstanceId, CommonSubscriptionResourceConstants.COMPONENT, resourceId, new SubscriberDirective[0]));
        }
        return new SubscriptionSubscriberList((Collection<? extends SubscriptionSubscriber>)subscribers);
    }

    private void verifyCalendar(String componentInstanceId, String resourceId, Collection<SubscriptionSubscriber> subscribers) {
        Calendar calendar = Calendar.getById((String)resourceId);
        if (calendar != null && calendar.getComponentInstanceId().equals(componentInstanceId)) {
            subscribers.addAll(SubscriptionServiceProvider.getSubscribeService().getSubscribers(CalendarSubscriptionResource.from(calendar)));
        }
    }
}

