/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import org.silverpeas.core.admin.component.model.PersonalComponent;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.notification.UserEvent;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.kernel.logging.SilverLogger;

@Bean
public class CalendarUserEventListener
extends CDIResourceEventListener<UserEvent> {
    public void onDeletion(UserEvent event) {
        User deletedUser = (User)event.getTransition().getBefore();
        try {
            Transaction.performInOne(() -> {
                Calendar.getByComponentInstanceId((String)PersonalComponentInstance.from(deletedUser, PersonalComponent.getByName("userCalendar").orElse(null)).getId()).forEach(Calendar::delete);
                return null;
            });
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
        }
    }
}

