/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.AbstractSearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteria;
import org.silverpeas.core.admin.user.model.SearchCriteriaVisitor;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class GroupsSearchCriteria
extends AbstractSearchCriteria {
    private static final String USER_ACCESS_LEVELS = "userAccessLevels";
    private static final String GROUP_ID = "groupId";
    private static final String USER_ID = "userId";
    private static final String SUPERGROUP_ID = "parentId";
    private static final String PROFILE_IDS = "profileIds";
    private static final String DOMAIN_IDS = "domainIds";
    private static final String INSTANCE_ID = "instanceId";
    private static final String WITH_CHILDREN = "withChildren";
    private static final String RESOURCE_ID = "resourceId";
    private static final String ROOT_GROUP = "mustBeRoot";
    private static final String NAME = "name";
    private static final String PAGINATION = "pagination";

    public GroupsSearchCriteria() {
        this.criteria.put(GROUP_ID, SearchCriteria.Constants.ANY);
    }

    @Override
    public GroupsSearchCriteria onName(String name) {
        if (StringUtil.isDefined((String)name)) {
            this.criteria.put(NAME, name);
        }
        return this;
    }

    public GroupsSearchCriteria clearOnName() {
        this.criteria.remove(NAME);
        return this;
    }

    @Override
    public GroupsSearchCriteria onComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.criteria.put(INSTANCE_ID, instanceId);
        }
        return this;
    }

    public GroupsSearchCriteria withChildren() {
        this.criteria.put(WITH_CHILDREN, true);
        return this;
    }

    @Override
    public GroupsSearchCriteria onRoleNames(String ... roleIds) {
        return (GroupsSearchCriteria)super.onRoleNames(roleIds);
    }

    public GroupsSearchCriteria onProfileIds(String ... profileIds) {
        if (ArrayUtil.isNotEmpty(profileIds)) {
            this.criteria.put(PROFILE_IDS, Arrays.stream(profileIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onGroupIds(String ... groupIds) {
        if (ArrayUtil.isNotEmpty(groupIds)) {
            this.criteria.put(GROUP_ID, Arrays.stream(groupIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    public GroupsSearchCriteria onAsRootGroup() {
        this.criteria.put(ROOT_GROUP, true);
        return this;
    }

    public GroupsSearchCriteria onSuperGroupId(String superGroupId) {
        if (StringUtil.isDefined((String)superGroupId)) {
            this.criteria.put(SUPERGROUP_ID, superGroupId);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onDomainIds(String ... domainIds) {
        if (ArrayUtil.isNotEmpty(domainIds)) {
            this.criteria.put(DOMAIN_IDS, Arrays.stream(domainIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onAccessLevels(UserAccessLevel ... accessLevels) {
        if (ArrayUtil.isNotEmpty(accessLevels)) {
            this.criteria.put(USER_ACCESS_LEVELS, accessLevels);
        }
        return this;
    }

    @Override
    public GroupsSearchCriteria onUserStatesToExclude(UserState ... userStates) {
        return (GroupsSearchCriteria)super.onUserStatesToExclude(userStates);
    }

    @Override
    public GroupsSearchCriteria includeRemovedUsers() {
        return (GroupsSearchCriteria)super.includeRemovedUsers();
    }

    public GroupsSearchCriteria onMixedDomainOrOnDomainId(String domainId) {
        if (StringUtil.isDefined((String)domainId)) {
            this.criteria.put(DOMAIN_IDS, new String[]{"-1", domainId});
        } else {
            this.criteria.put(DOMAIN_IDS, new String[]{"-1"});
        }
        return this;
    }

    public boolean isCriterionOnProfileIdsSet() {
        return this.criteria.containsKey(PROFILE_IDS);
    }

    public boolean isCriterionOnResourceIdSet() {
        return this.criteria.containsKey(RESOURCE_ID);
    }

    public boolean isCriterionOnComponentInstanceIdSet() {
        return this.criteria.containsKey(INSTANCE_ID);
    }

    public boolean isCriterionOnSuperGroupIdSet() {
        return this.criteria.containsKey(SUPERGROUP_ID);
    }

    public boolean isCriterionOnGroupIdsSet() {
        return this.criteria.containsKey(GROUP_ID) && ArrayUtils.isNotEmpty((Object[])((String[])this.criteria.get(GROUP_ID)));
    }

    public boolean isCriterionOnDomainIdSet() {
        return this.criteria.containsKey(DOMAIN_IDS) && ArrayUtil.isNotEmpty((String[])this.criteria.get(DOMAIN_IDS));
    }

    public boolean isCriterionOnAccessLevelsSet() {
        return this.criteria.containsKey(USER_ACCESS_LEVELS);
    }

    public boolean isCriterionOnMixedDomainIdSet() {
        if (this.criteria.containsKey(DOMAIN_IDS)) {
            String[] domainIds = (String[])this.criteria.get(DOMAIN_IDS);
            return Arrays.asList(domainIds).contains("-1");
        }
        return false;
    }

    public boolean isCriterionOnUserIdsSet() {
        return this.criteria.containsKey(USER_ID);
    }

    public boolean isCriterionOnNameSet() {
        return this.criteria.containsKey(NAME);
    }

    public boolean isCriterionOnPaginationSet() {
        return this.criteria.containsKey(PAGINATION);
    }

    public boolean childrenRequired() {
        return this.criteria.containsKey(WITH_CHILDREN);
    }

    public boolean mustBeRoot() {
        return this.criteria.containsKey(ROOT_GROUP);
    }

    public String[] getCriterionOnProfileIds() {
        return (String[])this.criteria.get(PROFILE_IDS);
    }

    @Override
    public boolean mustMatchAllRoles() {
        return this.isCriterionOnProfileIdsSet() && super.mustMatchAllRoles();
    }

    public String getCriterionOnResourceId() {
        return (String)this.criteria.get(RESOURCE_ID);
    }

    public String getCriterionOnComponentInstanceId() {
        return (String)this.criteria.get(INSTANCE_ID);
    }

    public String getCriterionOnSuperGroupId() {
        return (String)this.criteria.get(SUPERGROUP_ID);
    }

    public String[] getCriterionOnUserIds() {
        return (String[])this.criteria.get(USER_ID);
    }

    public String[] getCriterionOnGroupIds() {
        return (String[])this.criteria.get(GROUP_ID);
    }

    public String[] getCriterionOnDomainIds() {
        return (String[])this.criteria.get(DOMAIN_IDS);
    }

    public UserAccessLevel[] getCriterionOnAccessLevels() {
        return (UserAccessLevel[])this.criteria.get(USER_ACCESS_LEVELS);
    }

    public String getCriterionOnName() {
        return (String)this.criteria.get(NAME);
    }

    public PaginationPage getCriterionOnPagination() {
        return (PaginationPage)this.criteria.get(PAGINATION);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupsSearchCriteria other = (GroupsSearchCriteria)obj;
        return Objects.equals(this.criteria, other.criteria);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.criteria != null ? this.criteria.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.criteria.isEmpty();
    }

    @Override
    public void accept(SearchCriteriaVisitor visitor) throws SilverpeasRuntimeException {
        visitor.visit(this);
    }

    @Override
    public SearchCriteria onUserIds(String ... userIds) {
        if (ArrayUtil.isNotEmpty(userIds)) {
            this.criteria.put(USER_ID, Arrays.stream(userIds).filter(StringUtil::isDefined).toArray(String[]::new));
        }
        return this;
    }

    @Override
    public SearchCriteria onUserSpecificIds(String ... userSpecificIds) {
        return this;
    }

    @Override
    public SearchCriteria onResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.criteria.put(RESOURCE_ID, resourceId);
        }
        return this;
    }

    @Override
    public SearchCriteria onPagination(PaginationPage page) {
        if (page != null) {
            this.criteria.put(PAGINATION, page);
        }
        return this;
    }

    public SearchCriteria clearPagination() {
        this.criteria.remove(PAGINATION);
        return this;
    }
}

