/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.persistence.SpaceUserRoleRow;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.CollectionUtil;

@Repository
public class SpaceRoleDAO {
    private static final String SPACEUSERROLE_COLUMNS = "id,spaceId,name,RoleName,description,isInherited";
    private static final String FROM_GROUP_RELATION = " from ST_SpaceUserRole r, ST_SpaceUserRole_Group_Rel gr";
    private static final String WHERE_ID_EQUALS_SPACEUSERROLEID = " where r.id=gr.spaceUserRoleId";
    private static final String ROLE_SPACE_ID = "r.spaceId";
    private static final String FROM_USER_RELATION = " from ST_SpaceUserRole r, ST_SpaceUserRole_User_Rel ur";
    private static final String WHERE_ID_EQUALS_TO_SPACEUSERROLEID = " where r.id=ur.spaceUserRoleId";

    public List<SpaceUserRoleRow> getSpaceRoles(Connection con, List<String> groupIds, int userId, Collection<Integer> spaceIds) throws SQLException {
        ArrayList<SpaceUserRoleRow> roles = new ArrayList<SpaceUserRoleRow>();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            roles.addAll(this.getGroupRoles(con, spaceIds, groupIds));
        }
        if (userId != -1) {
            roles.addAll(this.getSpaceUserRoles(con, spaceIds, userId));
        }
        return roles;
    }

    private List<SpaceUserRoleRow> getGroupRoles(Connection con, Collection<Integer> spaceIds, List<String> groupIds) throws SQLException {
        ArrayList<SpaceUserRoleRow> roles = new ArrayList<SpaceUserRoleRow>();
        List groupIdsAsInt = groupIds.stream().map(Integer::parseInt).collect(Collectors.toList());
        JdbcSqlQuery.executeBySplittingOn(groupIdsAsInt, (groupIdBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)spaceIds, (spaceIdBatch, ignoreToo) -> this.getQueryCommons(FROM_GROUP_RELATION, WHERE_ID_EQUALS_SPACEUSERROLEID).and("gr.groupId", new Object[0]).in(groupIdBatch).and(ROLE_SPACE_ID, new Object[0]).in(spaceIdBatch).executeWith(con, r -> roles.add(SpaceUserRoleRow.fetch((ResultSet)r)))));
        return roles;
    }

    private List<SpaceUserRoleRow> getSpaceUserRoles(Connection con, Collection<Integer> spaceIds, int userId) throws SQLException {
        ArrayList<SpaceUserRoleRow> roles = new ArrayList<SpaceUserRoleRow>();
        JdbcSqlQuery.executeBySplittingOn(spaceIds, (idBatch, ignore) -> this.getQueryCommons(FROM_USER_RELATION, WHERE_ID_EQUALS_TO_SPACEUSERROLEID).and("ur.userId = ?", new Object[]{userId}).and(ROLE_SPACE_ID, new Object[0]).in(idBatch).executeWith(con, r -> roles.add(SpaceUserRoleRow.fetch((ResultSet)r))));
        return roles;
    }

    private JdbcSqlQuery getQueryCommons(String joins, String clauses) {
        return JdbcSqlQuery.select((String)"DISTINCT id,spaceId,name,RoleName,description,isInherited").addSqlPart(joins, new Object[0]).addSqlPart(clauses, new Object[0]);
    }
}

