/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space.quota.process.check;

import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.quota.offset.AbstractQuotaCountingOffset;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.process.io.file.FileHandler;

public class SpaceDataStorageQuotaCountingOffset
extends AbstractQuotaCountingOffset {
    private final SpaceInst space;
    private final FileHandler fileHandler;
    private long currentCountOffset = -1L;

    private SpaceDataStorageQuotaCountingOffset(SpaceInst space, FileHandler fileHandler) {
        this.space = space;
        this.fileHandler = fileHandler;
    }

    public static SpaceDataStorageQuotaCountingOffset from(SpaceInst space, FileHandler fileHandler) {
        return new SpaceDataStorageQuotaCountingOffset(space, fileHandler);
    }

    @Override
    public long getOffset() {
        if (this.currentCountOffset < 0L) {
            this.currentCountOffset = 0L;
            if (this.space != null) {
                for (SilverpeasComponentInstance component : this.space.getAllComponentInstances()) {
                    this.currentCountOffset += this.fileHandler.sizeOfSessionWorkingPath(component.getId());
                }
            }
        }
        return this.currentCountOffset;
    }
}

