/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasPersonalComponentInstance;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.GroupManager;
import org.silverpeas.core.admin.user.model.AbstractSearchCriteria;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SearchCriteriaVisitor;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SearchCriteriaOnUsersAndGroupsForComponentInstance
implements SearchCriteriaVisitor {
    private final Administration admin;
    private final GroupManager groupManager;

    @Inject
    public SearchCriteriaOnUsersAndGroupsForComponentInstance(Administration admin, GroupManager groupManager) {
        this.admin = admin;
        this.groupManager = groupManager;
    }

    @Override
    public void visit(UserDetailsSearchCriteria searchCriteria) throws SilverpeasRuntimeException {
        try {
            List<String> roleNames = SearchCriteriaOnUsersAndGroupsForComponentInstance.getRoleNames(searchCriteria);
            if (searchCriteria.isCriterionOnComponentInstanceIdSet()) {
                this.sethUsersOrGroupsPlayingRoles(searchCriteria, roleNames);
            } else if (!roleNames.isEmpty()) {
                SilverLogger.getLogger((Object)this).warn("searching users on role name(s) {0} without specifying a component instance identifier. No role name filtering is performed.", new Object[0]);
            }
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public void visit(GroupsSearchCriteria searchCriteria) throws SilverpeasRuntimeException {
        try {
            List<String> roleNames = SearchCriteriaOnUsersAndGroupsForComponentInstance.getRoleNames(searchCriteria);
            if (searchCriteria.isCriterionOnComponentInstanceIdSet()) {
                this.setRoleIdsMatchingRoles(searchCriteria, roleNames);
            } else if (!roleNames.isEmpty()) {
                SilverLogger.getLogger((Object)this).warn("searching groups on role name(s) {0} without specifying a component instance identifier. No role name filtering is performed.", new Object[0]);
            }
        }
        catch (AdminException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }

    @NonNull
    private static List<String> getRoleNames(AbstractSearchCriteria searchCriteria) {
        return Optional.ofNullable(searchCriteria.getCriterionOnRoleNames()).filter(ArrayUtil::isNotEmpty).stream().flatMap(Stream::of).collect(Collectors.toList());
    }

    private void setRoleIdsMatchingRoles(GroupsSearchCriteria searchCriteria, List<String> roleNames) throws AdminException {
        String instanceId = searchCriteria.getCriterionOnComponentInstanceId();
        SilverpeasComponentInstance instance = this.admin.getComponentInstance(instanceId);
        if (instance == null) {
            SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)"component instance", (Object)instanceId), new Object[0]);
            searchCriteria.clear();
        } else if (!roleNames.isEmpty() || !instance.isPublic()) {
            ArrayList profileIds = new ArrayList();
            if (!instance.isPersonal()) {
                List<ProfileInst> profiles = searchCriteria.isCriterionOnResourceIdSet() ? this.getProfileInstancesFor(searchCriteria.getCriterionOnResourceId(), instance.getId()) : this.admin.getComponentInst(instance.getId()).getAllProfilesInst();
                profiles.stream().filter(p -> roleNames.isEmpty() || roleNames.contains(p.getName())).map(BaseRightProfile::getId).forEach(profileIds::add);
                Optional.of(profileIds).filter(List::isEmpty).ifPresent(r -> r.add("-1000"));
            }
            searchCriteria.onProfileIds(profileIds.toArray(new String[0]));
        }
    }

    private void sethUsersOrGroupsPlayingRoles(UserDetailsSearchCriteria searchCriteria, List<String> roleNames) throws AdminException {
        String instanceId = searchCriteria.getCriterionOnComponentInstanceId();
        SilverpeasComponentInstance instance = this.admin.getComponentInstance(instanceId);
        if (instance == null) {
            SilverLogger.getLogger((Object)this).warn(SilverpeasExceptionMessages.failureOnGetting((String)"component instance", (Object)instanceId), new Object[0]);
            searchCriteria.clear();
        } else if (!roleNames.isEmpty() || !instance.isPublic()) {
            if (!instance.isPersonal()) {
                this.setGroupsPlayingRole(roleNames, instance, searchCriteria);
            } else {
                String currentUserId = this.getCurrentUserPlayingRole(roleNames, instance, searchCriteria);
                if (StringUtil.isDefined((String)currentUserId)) {
                    searchCriteria.onUserIds(currentUserId);
                } else {
                    searchCriteria.clear();
                }
            }
        }
    }

    private String getCurrentUserPlayingRole(List<String> listOfRoleNames, SilverpeasComponentInstance instance, UserDetailsSearchCriteria searchCriteria) {
        User user = ((SilverpeasPersonalComponentInstance)instance).getUser();
        return Optional.of(instance.getSilverpeasRolesFor(user).stream().map(SilverpeasRole::getName).collect(Collectors.toList())).filter(r -> listOfRoleNames.isEmpty() || !CollectionUtil.intersection((List)r, (List)listOfRoleNames).isEmpty()).filter(r -> !searchCriteria.isCriterionOnUserIdsSet() || ArrayUtil.contains(searchCriteria.getCriterionOnUserIds(), user.getId())).map(r -> user.getId()).orElse("");
    }

    private void setGroupsPlayingRole(List<String> roleNames, SilverpeasComponentInstance instance, UserDetailsSearchCriteria searchCriteria) throws AdminException {
        this.getRecursivelyValidGroupsIdPlaying(roleNames, instance, searchCriteria.getCriterionOnResourceId()).ifPresent(m -> {
            searchCriteria.withGroupsByRoles((Map<String, Set<String>>)m);
            if (searchCriteria.isCriterionOnAnyGroupSet()) {
                searchCriteria.onGroupIds((String[])m.values().stream().flatMap(Collection::stream).distinct().toArray(String[]::new));
            }
        });
    }

    private Optional<Map<String, Set<String>>> getRecursivelyValidGroupsIdPlaying(List<String> roleNames, SilverpeasComponentInstance instance, String resourceId) throws AdminException {
        List<ProfileInst> profiles = StringUtil.isDefined((String)resourceId) ? this.getProfileInstancesFor(resourceId, instance.getId()) : this.admin.getComponentInst(instance.getId()).getAllProfilesInst();
        HashMap<String, Set> groupIdsByRole = new HashMap<String, Set>(profiles.size());
        for (ProfileInst aProfile : profiles) {
            if (!roleNames.isEmpty() && !roleNames.contains(aProfile.getName())) continue;
            String roleName = aProfile.getName();
            Set allGroupIdsOfCurrentRole = Optional.ofNullable((Set)groupIdsByRole.get(roleName)).orElseGet(HashSet::new);
            List<String> groupIds = aProfile.getAllGroups();
            for (String aGroupId : groupIds) {
                allGroupIdsOfCurrentRole.add(aGroupId);
                allGroupIdsOfCurrentRole.addAll(this.groupManager.getAllSubGroupIdsRecursively(aGroupId));
            }
            if (allGroupIdsOfCurrentRole.isEmpty()) continue;
            groupIdsByRole.put(roleName, allGroupIdsOfCurrentRole);
        }
        return Optional.of(groupIdsByRole).filter(Predicate.not(Map::isEmpty));
    }

    private List<ProfileInst> getProfileInstancesFor(String resourceId, String instanceId) throws AdminException {
        Pattern objectIdPattern = Pattern.compile("([a-zA-Z]+)(\\d+)");
        Matcher matcher = objectIdPattern.matcher(resourceId);
        if (matcher.matches() && matcher.groupCount() == 2) {
            String type = matcher.group(1);
            String id = matcher.group(2);
            ProfiledObjectId objectId = new ProfiledObjectId(ProfiledObjectType.fromCode(type), id);
            return this.admin.getProfilesByObject(objectId, instanceId);
        }
        throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)("profiles on resource " + resourceId), (Object)("of component " + instanceId)), new String[0]);
    }
}

