/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.quota;

import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.quota.QuotaKey;
import org.silverpeas.core.admin.quota.constant.QuotaType;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.kernel.util.StringUtil;

public class UserDomainQuotaKey
implements QuotaKey {
    private final String resourceId;

    public static UserDomainQuotaKey from(UserDetail userDetail) {
        return new UserDomainQuotaKey(userDetail);
    }

    public static UserDomainQuotaKey from(Quota quota) {
        return new UserDomainQuotaKey(quota);
    }

    public static UserDomainQuotaKey from(Domain domain) {
        return new UserDomainQuotaKey(domain);
    }

    private UserDomainQuotaKey(UserDetail userDetail) {
        this.resourceId = userDetail.getDomainId();
    }

    private UserDomainQuotaKey(Quota quota) {
        this.resourceId = quota.getResourceId();
    }

    private UserDomainQuotaKey(Domain domain) {
        this.resourceId = domain.getId();
    }

    @Override
    public boolean isValid() {
        return StringUtil.isDefined((String)this.resourceId);
    }

    @Override
    public QuotaType getQuotaType() {
        return QuotaType.USERS_IN_DOMAIN;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }
}

