/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSettings;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPSynchroCache;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.UserManager;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPUser {
    private static final String LDAPUSER_GET_ALL_USERS = "LDAPUser.getAllUsers()";
    private LDAPSettings driverSettings = null;
    private LDAPSynchroCache synchroCache = null;
    private StringBuilder synchroReport = null;
    private boolean synchroInProcess = false;
    private DomainDriver driverParent = null;

    public void init(LDAPSettings driverSettings, DomainDriver driverParent, LDAPSynchroCache synchroCache) {
        this.driverSettings = driverSettings;
        this.driverParent = driverParent;
        this.synchroCache = synchroCache;
    }

    void beginSynchronization() {
        this.synchroReport = new StringBuilder();
        this.synchroInProcess = true;
    }

    String endSynchronization() {
        this.synchroInProcess = false;
        return this.synchroReport.toString();
    }

    public UserDetail[] getAllUsers(String lds, String extraFilter) throws AdminException {
        Object theFilter = extraFilter != null && !extraFilter.isEmpty() ? "(&" + extraFilter + this.driverSettings.getUsersFullFilter() + ")" : this.driverSettings.getUsersFullFilter();
        SynchroDomainReport.debug(LDAPUSER_GET_ALL_USERS, "Recherche des utilisateurs du domaine LDAP distant...");
        ArrayList<UserDetail> ldapUsers = new ArrayList<UserDetail>();
        LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), (String)theFilter, this.driverSettings.getUsersLoginField(), this.driverSettings.getUserAttributes());
        for (int i = 0; i < theEntries.length; ++i) {
            ldapUsers.add(this.translateUser(theEntries[i]));
            ((UserDetail)ldapUsers.get(i)).traceUser();
            SynchroDomainReport.debug(LDAPUSER_GET_ALL_USERS, "Utilisateur trouv\u00e9 no : " + i + ", login : " + ((UserDetail)ldapUsers.get(i)).getLogin() + ", " + ((UserDetail)ldapUsers.get(i)).getFirstName() + ", " + ((UserDetail)ldapUsers.get(i)).getLastName() + ", " + ((UserDetail)ldapUsers.get(i)).getEmailAddress());
        }
        SynchroDomainReport.debug(LDAPUSER_GET_ALL_USERS, "R\u00e9cup\u00e9ration de " + theEntries.length + " utilisateurs du domaine LDAP distant");
        return ldapUsers.toArray(new UserDetail[0]);
    }

    public List<UserFull> listUserFulls(String lds, Collection<String> ids, int domainId) throws AdminException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        String[] userAttributes = this.driverSettings.getUserAttributes();
        if (userAttributes != null && userAttributes.length > 0) {
            lAttrs.addAll(Arrays.asList(userAttributes));
            if (this.driverParent.getMapParameters() != null) {
                lAttrs.addAll(Arrays.asList(this.driverParent.getMapParameters()));
            }
        }
        ArrayList<UserFull> users = new ArrayList<UserFull>(ids.size());
        for (Collection idBatch : CollectionUtil.split(ids)) {
            List<LDAPEntry> entries = LDAPUtility.getEntriesFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(idBatch), lAttrs.toArray(new String[0]));
            Map<String, String> spUserIdByUserDN = this.mapSpUserIdByUserDN(lds, entries, domainId);
            for (LDAPEntry entry : entries) {
                users.add(this.translateUserFull(lds, entry, spUserIdByUserDN));
            }
        }
        return users;
    }

    public List<UserDetail> listUsers(String lds, Collection<String> ids) throws AdminException {
        ArrayList<UserDetail> users = new ArrayList<UserDetail>(ids.size());
        for (Collection idBatch : CollectionUtil.split(ids)) {
            List<LDAPEntry> entries = LDAPUtility.getEntriesFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(idBatch), this.driverSettings.getUserAttributes());
            for (LDAPEntry entry : entries) {
                users.add(this.translateUser(entry));
            }
        }
        return users;
    }

    UserDetail getUserByLogin(String lds, String loginUser) throws AdminException {
        LDAPEntry theEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersLoginFilter(loginUser), this.driverSettings.getUserAttributes());
        return this.translateUser(theEntry);
    }

    private void translateCommonUserData(LDAPEntry ldapUser, UserDetail silverpeasUser) {
        this.setUserDetailCommonAttribute(ldapUser, silverpeasUser);
        String userAccountControlAttribute = this.driverSettings.getUsersAccountControl();
        String disabledUserAccountFlag = this.driverSettings.getUsersDisabledAccountFlag();
        if (this.isRedirection(userAccountControlAttribute, disabledUserAccountFlag)) {
            String usersAccountControl = LDAPUtility.getFirstAttributeValue(ldapUser, userAccountControlAttribute);
            if (!StringUtil.isDefined((String)usersAccountControl)) {
                usersAccountControl = "";
            }
            this.setUserDetailState(silverpeasUser, disabledUserAccountFlag, usersAccountControl);
        }
    }

    private void setUserDetailState(UserDetail silverpeasDistantUser, String disabledUserAccountFlag, String usersAccountControl) {
        if (StringUtil.isLong((String)usersAccountControl)) {
            if (StringUtil.isLong((String)disabledUserAccountFlag)) {
                long disabledUserAccountFlagAsLong;
                long currentAccountControlFlags = Long.parseLong(usersAccountControl);
                if ((currentAccountControlFlags & (disabledUserAccountFlagAsLong = Long.parseLong(disabledUserAccountFlag))) == disabledUserAccountFlagAsLong) {
                    silverpeasDistantUser.setState(UserState.DEACTIVATED);
                } else {
                    silverpeasDistantUser.setState(UserState.VALID);
                }
            }
        } else if (usersAccountControl.matches("(?i)(.*[ ;,|]+|)" + disabledUserAccountFlag + "([ ;,|]+.*|)")) {
            silverpeasDistantUser.setState(UserState.DEACTIVATED);
        } else {
            silverpeasDistantUser.setState(UserState.VALID);
        }
    }

    private void setUserDetailCommonAttribute(LDAPEntry ldapUser, UserDetail silverpeasDistantUser) {
        silverpeasDistantUser.setSpecificId(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersIdField()));
        silverpeasDistantUser.setLogin(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersLoginField()));
        silverpeasDistantUser.setFirstName(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersFirstNameField()));
        silverpeasDistantUser.setLastName(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersLastNameField()));
        silverpeasDistantUser.setEmailAddress(LDAPUtility.getFirstAttributeValue(ldapUser, this.driverSettings.getUsersEmailField()));
        silverpeasDistantUser.setAccessLevel(null);
    }

    private UserFull translateUserFull(String lds, LDAPEntry userEntry, Map<String, String> spUserIdByUserDN) throws AdminException {
        UserFull userInfos = new UserFull(this.driverParent);
        String[] keys = this.driverParent.getPropertiesNames();
        this.translateCommonUserData(userEntry, userInfos);
        for (String key : keys) {
            DomainProperty curProp = this.driverParent.getProperty(key);
            if ("USERID".equals(curProp.getType())) {
                String subUserDN = LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter());
                if (subUserDN == null || subUserDN.isEmpty()) continue;
                this.setUserProperty(userInfos, curProp, subUserDN, spUserIdByUserDN);
                continue;
            }
            if (this.isRedirection(curProp.getRedirectOU(), curProp.getRedirectAttribute())) {
                this.setRedirectedProperty(lds, userEntry, curProp, userInfos);
                continue;
            }
            userInfos.setValue(curProp.getName(), LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter()));
        }
        return userInfos;
    }

    private Map<String, String> mapSpUserIdByUserDN(String lds, List<LDAPEntry> userEntries, int domainId) throws AdminException {
        List parameters = Stream.of(this.driverParent.getPropertiesNames()).map(this.driverParent::getProperty).filter(p -> "USERID".equals(p.getType())).map(DomainProperty::getMapParameter).collect(Collectors.toList());
        Set bossDNs = userEntries.stream().flatMap(e -> parameters.stream().map(p -> {
            String subUserDN = LDAPUtility.getFirstAttributeValue(e, p);
            if (subUserDN != null && !subUserDN.isEmpty()) {
                return subUserDN;
            }
            return null;
        }).filter(Objects::nonNull)).map(d -> d.substring(0, d.indexOf(","))).collect(Collectors.toSet());
        if (!bossDNs.isEmpty()) {
            String usersIdField = this.driverSettings.getUsersIdField();
            Stream<LDAPEntry> entries = Stream.empty();
            for (Collection dnBatch : CollectionUtil.split(bossDNs, (int)1)) {
                entries = Stream.concat(entries, LDAPUtility.getEntriesFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersManualFilter(dnBatch), new String[]{usersIdField}).stream());
            }
            Map<String, String> dnBySpecificId = entries.collect(Collectors.toMap(e -> LDAPUtility.getFirstAttributeValue(e, usersIdField), LDAPEntry::getDN));
            if (!dnBySpecificId.isEmpty()) {
                return UserManager.get().getUsersBySpecificIdsAndDomainId(dnBySpecificId.keySet(), String.valueOf(domainId)).stream().collect(Collectors.toMap(u -> (String)dnBySpecificId.get(u.getSpecificId()), UserDetail::getId));
            }
        }
        return Map.of();
    }

    private void setUserProperty(UserFull userInfos, DomainProperty curProp, String subUserDN, Map<String, String> spUserIdByUserDN) {
        String userId = spUserIdByUserDN.get(subUserDN);
        if (userId != null) {
            userInfos.setValue(curProp.getName(), userId);
        } else if (this.synchroInProcess) {
            this.synchroReport.append(String.format("PB getting '%s' data: %s%n", curProp.getName(), subUserDN));
        }
    }

    private void setRedirectedProperty(String lds, LDAPEntry userEntry, DomainProperty curProp, UserFull userInfos) throws AdminException {
        String filter;
        String baseDN;
        LDAPEntry subUserEntry;
        String cn = LDAPUtility.getFirstAttributeValue(userEntry, curProp.getMapParameter());
        if (StringUtil.isDefined((String)cn) && (subUserEntry = LDAPUtility.getFirstEntryFromSearch(lds, baseDN = curProp.getRedirectOU(), 2, filter = "(cn=" + cn + ")", this.driverSettings.getUserAttributes())) != null) {
            userInfos.setValue(curProp.getName(), LDAPUtility.getFirstAttributeValue(subUserEntry, curProp.getRedirectAttribute()));
        }
    }

    private boolean isRedirection(String redirectOU, String redirectAttribute) {
        return StringUtil.isDefined((String)redirectOU) && StringUtil.isDefined((String)redirectAttribute);
    }

    private UserDetail translateUser(LDAPEntry userEntry) throws AdminException {
        UserDetail userInfos = new UserDetail();
        if (userEntry == null) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)"LDAP user entry"), new String[0]);
        }
        this.translateCommonUserData(userEntry, userInfos);
        this.synchroCache.addUser(userEntry);
        return userInfos;
    }

    public String[] getUserAttributes() {
        ArrayList<String> lAttrs = new ArrayList<String>();
        String[] userAttributes = this.driverSettings.getUserAttributes();
        if (userAttributes != null) {
            lAttrs.addAll(Arrays.asList(userAttributes));
            if (this.driverParent.getMapParameters() != null) {
                lAttrs.addAll(Arrays.asList(this.driverParent.getMapParameters()));
            }
        }
        return lAttrs.toArray(new String[0]);
    }
}

