/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.googledriver;

import com.google.api.client.json.GenericJson;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.expression.PrefixedNotationExpressionEngine;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

class GoogleUserFilter<T extends GenericJson> {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("(?i)^\\s*[(].+[)]\\s*$");
    private static final Pattern CRITERION_ARRAY_PATTERN = Pattern.compile("(?i)^\\s*(\\S+)\\s*\\[\\s*(\\S+)\\s*]$");
    private static final String CRITERION_PART_DECODER = "(?i)^\\s*(\\S+)\\s*";
    private final List<T> allUsers;
    private final String combinationRule;

    GoogleUserFilter(List<T> allUsers, String combinationRule) {
        this.allUsers = allUsers;
        this.combinationRule = combinationRule;
    }

    public List<T> apply() {
        if (StringUtil.isNotDefined((String)this.combinationRule)) {
            return new ArrayList<T>(this.allUsers);
        }
        return this.evaluateCombinationRule();
    }

    private String getRuleExpression(PrefixedNotationExpressionEngine<List<T>> combinationEngine) {
        String rule = this.combinationRule != null ? this.combinationRule : "";
        Matcher matcher = EXPRESSION_PATTERN.matcher(rule);
        if (!(matcher.matches() || rule.contains("\\") || combinationEngine.detectOperator(rule))) {
            rule = rule.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)");
        } else {
            StringBuilder newRule = new StringBuilder();
            int nbOpening = 0;
            for (int i = 0; i < rule.length(); ++i) {
                char currentChar = rule.charAt(i);
                if (currentChar == '[') {
                    ++nbOpening;
                } else if (currentChar == ']') {
                    --nbOpening;
                } else if (nbOpening > 0 && (currentChar == '(' || currentChar == ')')) {
                    newRule.append("\\");
                }
                newRule.append(currentChar);
            }
            rule = newRule.toString();
        }
        return rule;
    }

    private List<T> evaluateCombinationRule() {
        PrefixedNotationExpressionEngine.OperatorFunction negate = new PrefixedNotationExpressionEngine.OperatorFunction("!", (computed, users) -> {
            if (computed != Collections.EMPTY_LIST) {
                return new ArrayList();
            }
            Set idsToRemove = users.stream().map(u -> (String)u.get((Object)"id")).collect(Collectors.toSet());
            return this.allUsers.stream().filter(u -> {
                String id = (String)u.get((Object)"id");
                return !idsToRemove.contains(id);
            }).collect(Collectors.toList());
        });
        PrefixedNotationExpressionEngine.OperatorFunction and = new PrefixedNotationExpressionEngine.OperatorFunction("&", (computed, users) -> {
            List safeComputed = computed == Collections.EMPTY_LIST ? users : computed;
            return CollectionUtil.intersection((List)safeComputed, (List)users, u -> u.get((Object)"id"));
        });
        PrefixedNotationExpressionEngine.OperatorFunction or = new PrefixedNotationExpressionEngine.OperatorFunction("|", (computed, users) -> {
            List safeComputed = computed == Collections.EMPTY_LIST ? Collections.emptyList() : computed;
            return CollectionUtil.union((List)safeComputed, (List)users);
        });
        Function<String, List> customMaskRuleToUsers = this::evaluateCriterion;
        PrefixedNotationExpressionEngine combinationEngine = PrefixedNotationExpressionEngine.from(customMaskRuleToUsers, (PrefixedNotationExpressionEngine.OperatorFunction[])new PrefixedNotationExpressionEngine.OperatorFunction[]{negate, and, or});
        String expression = this.getRuleExpression(combinationEngine);
        return (List)combinationEngine.evaluate(expression);
    }

    private List<T> evaluateCriterion(String criterion) {
        if (criterion == null) {
            return Collections.emptyList();
        }
        CriterionDecoder criterionDecoder = new WithArrayCriterionDecoder(criterion);
        if (!criterionDecoder.isMatching()) {
            criterionDecoder = new SimpleCriterionDecoder(criterion);
        }
        if (!criterionDecoder.isMatching()) {
            String message = "ground rule '" + criterion + "' is not correct !";
            SilverLogger.getLogger((Object)this).error(message, new Object[0]);
            throw new SilverpeasRuntimeException(message);
        }
        WithArrayCriterionDecoder decoder = criterionDecoder;
        return this.allUsers.stream().filter(u -> this.filterUser(decoder, u)).collect(Collectors.toList());
    }

    private boolean filterUser(CriterionDecoder criterionDecoder, T data) {
        GenericJson attributeValues;
        String criterion = criterionDecoder.getCriterion();
        String path = criterionDecoder.getPath();
        String[] explodedPath = criterionDecoder.getExplodedPath();
        String subRule = criterionDecoder.getSubRule();
        String expectedValue = criterionDecoder.getExpectedValue().toLowerCase();
        try {
            attributeValues = this.resolvePath(criterionDecoder, 0, (GenericJson)data);
        }
        catch (UserFilterException e) {
            throw e.withCriterion(criterion).withPath(path);
        }
        String attr = StringUtil.defaultStringIfNotDefined((String)explodedPath[explodedPath.length - 1]);
        boolean filterResult = StringUtil.isNotDefined((String)attr) ? false : (StringUtil.isDefined((String)subRule) ? this.applySubRule(subRule, data, attr) : StringUtil.likeIgnoreCase((String)String.valueOf(attributeValues.get((Object)attr)), (String)expectedValue));
        return filterResult;
    }

    private boolean applySubRule(String subRule, T data, String attr) {
        List subData;
        Object o = data.get((Object)attr);
        boolean filterResult = o instanceof List ? !new GoogleUserFilter(subData = ((List)o).stream().map(m -> {
            GenericJson j = new GenericJson();
            m.forEach((arg_0, arg_1) -> ((GenericJson)j).set(arg_0, arg_1));
            j.set("id", data.get((Object)"id"));
            return j;
        }).collect(Collectors.toList()), subRule).apply().isEmpty() : false;
        return filterResult;
    }

    private GenericJson resolvePath(CriterionDecoder criterionDecoder, int pathLevel, GenericJson data) {
        String[] path = criterionDecoder.getExplodedPath();
        if (path.length == pathLevel + 1) {
            return data;
        }
        String pathPart = path[pathLevel];
        Object subData = data.get((Object)pathPart);
        if (!(subData instanceof GenericJson) && subData instanceof Map) {
            GenericJson temp = new GenericJson();
            ((Map)subData).forEach((arg_0, arg_1) -> ((GenericJson)temp).set(arg_0, arg_1));
            temp.set("id", data.get((Object)"id"));
            subData = temp;
        } else if ("customSchemas".equals(path[0]) && subData == null) {
            subData = new GenericJson();
        }
        if (subData == null) {
            throw new UserFilterException(ERROR.NOT_VALID_PATH_PART).withPathPart(pathPart);
        }
        if (!(subData instanceof GenericJson)) {
            throw new UserFilterException(ERROR.FINAL_VALUE_PATH_PART).withPathPart(pathPart);
        }
        return this.resolvePath(criterionDecoder, pathLevel + 1, (GenericJson)subData);
    }

    public static class UserFilterException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1541302731885140639L;
        private final ERROR type;
        private final String[] elements = new String[3];

        UserFilterException(ERROR type) {
            this.type = type;
        }

        @Override
        public String getMessage() {
            String message = this.type == ERROR.BAD_OPERATOR ? MessageFormat.format("clause ''{0}'' uses a bad operator", this.elements[0]) : (this.type == ERROR.NOT_VALID_PATH_PART ? MessageFormat.format("path part ''{2}'' of ''{1}'' in clause ''{0}'' is not valid", this.elements) : (this.type == ERROR.FINAL_VALUE_PATH_PART ? MessageFormat.format("path part ''{2}'' of ''{1}'' in clause ''{0}'' represents a final value", this.elements) : super.getMessage()));
            return message;
        }

        public ERROR getType() {
            return this.type;
        }

        public String getCriterion() {
            return this.elements[0];
        }

        UserFilterException withCriterion(String clause) {
            this.elements[0] = clause;
            return this;
        }

        public String getPath() {
            return this.elements[1];
        }

        UserFilterException withPath(String path) {
            this.elements[1] = path;
            return this;
        }

        String getPathPart() {
            return this.elements[2];
        }

        UserFilterException withPathPart(String pathPart) {
            this.elements[2] = pathPart;
            return this;
        }
    }

    private static class SimpleCriterionDecoder
    extends CriterionDecoder {
        SimpleCriterionDecoder(String criterion) {
            super(criterion);
        }

        @Override
        protected void decode() {
            String[] explodedCriterion = this.getCriterion().split("[=]");
            boolean bl = this.match = explodedCriterion.length == 2;
            if (this.match) {
                this.path = explodedCriterion[0].replaceAll(GoogleUserFilter.CRITERION_PART_DECODER, "$1");
                this.explodedPath = this.path.split("[.]");
                this.expectedValue = explodedCriterion[1].replaceAll(GoogleUserFilter.CRITERION_PART_DECODER, "$1");
            }
        }
    }

    private static class WithArrayCriterionDecoder
    extends CriterionDecoder {
        WithArrayCriterionDecoder(String criterion) {
            super(criterion);
        }

        @Override
        protected void decode() {
            Matcher matcher = CRITERION_ARRAY_PATTERN.matcher(this.getCriterion());
            if (matcher.find()) {
                this.path = matcher.group(1);
                this.explodedPath = this.path.split("[.]");
                this.subRule = matcher.group(2);
                this.match = true;
            }
        }
    }

    private static abstract class CriterionDecoder {
        private final String criterion;
        String path = "";
        String[] explodedPath;
        String operator = "";
        String expectedValue = "";
        String subRule = "";
        boolean match = false;

        CriterionDecoder(String criterion) {
            this.criterion = criterion;
            this.decode();
            this.explodedPath = this.path.split("[.]");
        }

        protected abstract void decode();

        public boolean isMatching() {
            return this.match;
        }

        public String getCriterion() {
            return this.criterion;
        }

        public String getPath() {
            return this.path;
        }

        String[] getExplodedPath() {
            return this.explodedPath;
        }

        public String getOperator() {
            return this.operator;
        }

        String getExpectedValue() {
            return this.expectedValue;
        }

        String getSubRule() {
            return this.subRule;
        }
    }

    public static enum ERROR {
        BAD_OPERATOR,
        NOT_VALID_PATH_PART,
        FINAL_VALUE_PATH_PART;

    }
}

