/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.kernel.bundle.SettingBundle;

public interface DomainDriver {
    public void init(int var1, String var2, String var3) throws AdminException;

    public String[] getPropertiesNames();

    public DomainProperty getProperty(String var1);

    public String[] getMapParameters();

    public List<DomainProperty> getPropertiesToImport(String var1);

    public void addPropertiesToImport(List<DomainProperty> var1);

    public void addPropertiesToImport(List<DomainProperty> var1, Map<String, String> var2);

    public Map<String, String> getPropertiesLabels(String var1);

    public Map<String, String> getPropertiesDescriptions(String var1);

    public void initFromProperties(SettingBundle var1) throws AdminException;

    public long getDriverActions();

    public boolean isSynchroOnLoginEnabled();

    public boolean isSynchroThreaded();

    public boolean isSynchroOnLoginRecursToGroups();

    public boolean isGroupsInheritProfiles();

    public boolean mustImportUsers();

    public boolean isX509CertificateEnabled();

    public void beginSynchronization() throws AdminException;

    public boolean isSynchroInProcess() throws AdminException;

    public String endSynchronization(boolean var1) throws AdminException;

    public UserDetail importUser(String var1) throws AdminException;

    public void removeUser(String var1) throws AdminException;

    public UserDetail synchroUser(String var1) throws AdminException;

    public String createUser(UserDetail var1) throws AdminException;

    public void deleteUser(String var1) throws AdminException;

    public void updateUserFull(UserFull var1) throws AdminException;

    public void updateUserDetail(UserDetail var1) throws AdminException;

    public UserDetail getUser(String var1) throws AdminException;

    public List<UserDetail> listUsers(Collection<String> var1) throws AdminException;

    public UserFull getUserFull(String var1) throws AdminException;

    public List<UserFull> listUserFulls(Collection<String> var1) throws AdminException;

    public String[] getUserMemberGroupIds(String var1) throws AdminException;

    public UserDetail[] getAllUsers() throws AdminException;

    public UserDetail[] getUsersBySpecificProperty(String var1, String var2) throws AdminException;

    public UserDetail[] getUsersByQuery(Map<String, String> var1) throws AdminException;

    public GroupDetail importGroup(String var1) throws AdminException;

    public void removeGroup(String var1) throws AdminException;

    public GroupDetail synchroGroup(String var1) throws AdminException;

    public String createGroup(GroupDetail var1) throws AdminException;

    public void deleteGroup(String var1) throws AdminException;

    public void updateGroup(GroupDetail var1) throws AdminException;

    public GroupDetail getGroup(String var1) throws AdminException;

    public GroupDetail getGroupByName(String var1) throws AdminException;

    public GroupDetail[] getGroups(String var1) throws AdminException;

    public GroupDetail[] getAllGroups() throws AdminException;

    public GroupDetail[] getAllRootGroups() throws AdminException;

    public String[] getGroupMemberGroupIds(String var1) throws AdminException;

    public List<String> getUserAttributes() throws AdminException;

    public void resetPassword(UserDetail var1, String var2) throws AdminException;

    public void resetEncryptedPassword(UserDetail var1, String var2) throws AdminException;

    default public Optional<UserFilterManager> getUserFilterManager() {
        return Optional.empty();
    }

    public static interface UserFilterManager {
        public String getRuleKey();

        public String getRule();

        public User[] validateRule(String var1) throws AdminException;

        public User[] saveRule(String var1) throws AdminException;
    }

    public static class ActionConstants {
        public static final long ACTION_NONE = 0L;
        public static final long ACTION_READ_USER = 1L;
        public static final long ACTION_READ_GROUP = 2L;
        public static final long ACTION_UPDATE_USER = 4L;
        public static final long ACTION_UPDATE_GROUP = 8L;
        public static final long ACTION_CREATE_USER = 16L;
        public static final long ACTION_CREATE_GROUP = 32L;
        public static final long ACTION_DELETE_USER = 64L;
        public static final long ACTION_DELETE_GROUP = 128L;
        public static final long ACTION_EDIT_USER_IN_GROUP = 256L;
        public static final long ACTION_IMPORT_USER = 512L;
        public static final long ACTION_SYNCHRO_USER = 1024L;
        public static final long ACTION_REMOVE_USER = 2048L;
        public static final long ACTION_IMPORT_GROUP = 4096L;
        public static final long ACTION_SYNCHRO_GROUP = 8192L;
        public static final long ACTION_REMOVE_GROUP = 16384L;
        public static final long ACTION_X509_USER = 32768L;
        public static final long ACTION_RECEIVE_USER = 65536L;
        public static final long ACTION_RECEIVE_GROUP = 131072L;
        public static final long ACTION_UNSYNCHRO_USER = 262144L;
        public static final long ACTION_UNSYNCHRO_GROUP = 524288L;
        public static final long ACTION_MASK_ALL = 0xFFFFFFFFL;
        public static final long ACTION_MASK_RW = 511L;
        public static final long ACTION_MASK_RO = 818691L;
        public static final long ACTION_MASK_RO_PULL_USER = 1025L;
        public static final long ACTION_MASK_RO_LISTENER = 215043L;
        public static final long ACTION_MASK_MIXED_GROUPS = 426L;

        private ActionConstants() {
        }
    }
}

