/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.LocalizedGroupOfParameters;
import org.silverpeas.core.admin.component.model.LocalizedParameter;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.ParameterList;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;

public class LocalizedParameterList
extends ArrayList<LocalizedParameter> {
    private static final long serialVersionUID = 8621941317822315512L;
    private final String lang;

    protected LocalizedParameterList(LocalizedGroupOfParameters bundle, ParameterList parameters) {
        super(parameters.stream().map(p -> new LocalizedParameter(bundle, (Parameter)p)).collect(Collectors.toList()));
        this.lang = bundle.getLanguage();
    }

    public LocalizedParameterList(SilverpeasComponent component, ParameterList parameters, String lang) {
        super(parameters.stream().map(p -> new LocalizedParameter(component, (Parameter)p, lang)).collect(Collectors.toList()));
        this.lang = lang;
    }

    public List<LocalizedParameter> getVisibleParameters() {
        ArrayList<LocalizedParameter> parameters = new ArrayList<LocalizedParameter>();
        for (LocalizedParameter parameter : this) {
            if (!parameter.isVisible()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public List<LocalizedParameter> getHiddenParameters() {
        ArrayList<LocalizedParameter> parameters = new ArrayList<LocalizedParameter>();
        for (LocalizedParameter parameter : this) {
            if (!parameter.isHidden()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public boolean isVisible() {
        return !this.getVisibleParameters().isEmpty();
    }

    public String getLanguage() {
        return this.lang;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

