/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.impl.LPInterpreter;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SafeTripleIterator
implements ClosableIterator<Triple> {
    protected ExtendedIterator<Triple> matchIterator;
    protected long offset = 0L;
    protected TriplePattern goal;
    protected BackwardRuleInfGraphI infGraph;

    public SafeTripleIterator(LPInterpreter interpreter, TriplePattern goal) {
        this.infGraph = interpreter.getEngine().getInfGraph();
        this.goal = goal;
        this.restart();
    }

    protected void restart() {
        this.matchIterator = this.infGraph.findDataMatches(this.goal);
        int i = 0;
        while ((long)i < this.offset) {
            this.matchIterator.next();
            ++i;
        }
    }

    @Override
    public void close() {
        this.matchIterator.close();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.matchIterator.hasNext();
        }
        catch (Exception e) {
            this.restart();
            return this.matchIterator.hasNext();
        }
    }

    @Override
    public Triple next() {
        try {
            ++this.offset;
            return (Triple)this.matchIterator.next();
        }
        catch (Exception e) {
            this.restart();
            return (Triple)this.matchIterator.next();
        }
    }
}

