/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.notification.FormsOnlineValidationRequestUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;

public class FormsOnlineProcessedRequestFollowingUserNotification
extends FormsOnlineValidationRequestUserNotification {
    private final List<String> usersToBeNotified;

    public FormsOnlineProcessedRequestFollowingUserNotification(FormInstance resource, NotifAction action) {
        super(resource, action);
        FormInstanceValidationType latestValidation = resource.getValidations().getLatestValidation().map(FormInstanceValidation::getValidationType).orElse(null);
        this.usersToBeNotified = resource.getPreviousValidations().stream().filter(v -> v.getValidationType() != latestValidation).filter(FormInstanceValidation::isFollower).map(ContributionValidation::getValidator).map(User::getId).collect(Collectors.toList());
    }

    protected void perform(FormInstance resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    @Override
    protected String getBundleSubjectKey() {
        return "formsOnline.msgFormProcessed.follower";
    }

    @Override
    protected String getTemplateFileName() {
        return "notificationProcessed";
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        return this.usersToBeNotified;
    }

    @Override
    protected void performTemplateData(String language, FormInstance resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        ((FormInstance)this.getResource()).getValidations().getLatestValidation().ifPresent(v -> template.setAttribute("validation", (Object)v));
    }
}

