/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.notification;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.notification.AbstractFormsOnlineRequestUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

public class FormsOnlineCanceledRequestUserNotification
extends AbstractFormsOnlineRequestUserNotification {
    private final List<String> usersToBeNotified;

    public FormsOnlineCanceledRequestUserNotification(FormInstance resource) {
        super(resource, NotifAction.CANCELED);
        this.usersToBeNotified = resource.getPreviousValidations().stream().map(ContributionValidation::getValidator).map(User::getId).collect(Collectors.toList());
    }

    protected void perform(FormInstance resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected String getBundleSubjectKey() {
        return "formsOnline.msgFormCanceled";
    }

    protected String getTemplateFileName() {
        return "notificationCanceled";
    }

    protected Collection<String> getUserIdsToNotify() {
        return this.usersToBeNotified;
    }
}

