/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private static final String CLASS_FILE_SUFFIX = ".class";

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        for (String packageName : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(packageName);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.isEligibleForOverriding(name)) {
            result = this.loadClassForOverriding(name);
        }
        if (result != null) {
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        return !this.isExcluded(className);
    }

    protected Class<?> loadClassForOverriding(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> result = this.findLoadedClass(name);
        if (result == null && (bytes = this.loadBytesForClass(name)) != null) {
            result = this.defineClass(name, bytes, 0, bytes.length);
        }
        return result;
    }

    protected byte[] loadBytesForClass(String name) throws ClassNotFoundException {
        InputStream is = this.openStreamForClass(name);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray(is);
            return this.transformIfNecessary(name, bytes);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name) {
        String internalName = name.replace('.', '/') + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name, byte[] bytes) {
        return bytes;
    }
}

