/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar.api;

import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class CalendarEntry {
    private static final long serialVersionUID = 6712231674470680038L;
    private static final int MINIMUM_PRIORITY = 0;
    private static final int MAXIMUM_PRIORITY = 9;
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd");
    private static final FastDateFormat TIME_FORMATTER = FastDateFormat.getInstance((String)"HH:mm");
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";
    private static final String CONFIDENTIAL = "confidential";
    private String id = null;
    private String name = null;
    private String delegatorId = null;
    private String description = null;
    private String classification = "private";
    private String startDate = null;
    private String startHour = null;
    private String endDate = null;
    private String endHour = null;
    private int priority = 2;
    private String externalId = null;

    public CalendarEntry(String name, String delegatorId) {
        if (this.isDefined(name)) {
            this.name = name;
        }
        if (this.isDefined(delegatorId)) {
            this.delegatorId = delegatorId;
        }
    }

    public String getEndDay() {
        if (this.endDate == null) {
            return this.getStartDay();
        }
        return this.endDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.isDefined(name) ? name : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = this.isDefined(id) ? id : null;
    }

    public void setDelegatorId(String delegatorId) {
        this.delegatorId = this.isDefined(delegatorId) ? delegatorId : null;
    }

    public String getDelegatorId() {
        return this.delegatorId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        if (classification == null) {
            return;
        }
        if (PRIVATE.equalsIgnoreCase(classification)) {
            this.classification = PRIVATE;
        } else if (PUBLIC.equalsIgnoreCase(classification)) {
            this.classification = PUBLIC;
        } else if (CONFIDENTIAL.equalsIgnoreCase(classification)) {
            this.classification = CONFIDENTIAL;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority > 9 ? 9 : (newPriority < 0 ? 0 : newPriority);
    }

    public void setStartDay(Date date) {
        if (date == null) {
            this.startDate = null;
            return;
        }
        this.startDate = CalendarEntry.formatDate(date);
    }

    public void setStartHour(Date hour) {
        if (hour == null) {
            this.startHour = null;
            return;
        }
        this.startHour = CalendarEntry.formatTime(hour);
    }

    public String getStartDay() {
        return this.startDate;
    }

    public String getStartHour() {
        return this.startHour;
    }

    public void setEndDay(Date date) {
        if (date == null) {
            this.endDate = null;
            return;
        }
        this.endDate = CalendarEntry.formatDate(date);
    }

    public void setEndHour(Date hour) {
        if (hour == null) {
            this.endHour = null;
            return;
        }
        this.endHour = CalendarEntry.formatTime(hour);
    }

    public String getEndHour() {
        return this.endHour;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String outlookId) {
        this.externalId = outlookId;
    }

    private boolean isDefined(String parameter) {
        return parameter != null && !parameter.trim().isEmpty() && !"null".equalsIgnoreCase(parameter);
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_FORMATTER.format(date);
    }

    private static String formatTime(Date date) {
        if (date == null) {
            return null;
        }
        return TIME_FORMATTER.format(date);
    }

    public String toString() {
        return "JournalHeader{id=" + this.id + ", name=" + this.name + ", delegatorId=" + this.delegatorId + ", description=" + this.description + ", classification=" + this.classification + ", startDate=" + this.startDate + ", startHour=" + this.startHour + ", endDate=" + this.endDate + ", endHour=" + this.endHour + ", priority=" + this.priority + ", externalId=" + this.externalId + '}';
    }
}

