/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.flipkart.zjsonpatch.JsonDiff;
import edu.psu.swe.scim.server.provider.PrioritySortingComparitor;
import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.data.PatchOperation;
import edu.psu.swe.scim.spec.protocol.data.PatchOperationPath;
import edu.psu.swe.scim.spec.protocol.filter.AttributeComparisonExpression;
import edu.psu.swe.scim.spec.protocol.filter.CompareOperator;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.ValuePathExpression;
import edu.psu.swe.scim.spec.resources.ScimExtension;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.resources.ScimUser;
import edu.psu.swe.scim.spec.resources.TypedAttribute;
import edu.psu.swe.scim.spec.schema.AttributeContainer;
import edu.psu.swe.scim.spec.schema.Schema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UpdateRequest<T extends ScimResource> {
    private static final Logger log = LoggerFactory.getLogger(UpdateRequest.class);
    private static final String OPERATION = "op";
    private static final String PATH = "path";
    private static final String VALUE = "value";
    private String id;
    private T resource;
    private T original;
    private List<PatchOperation> patchOperations;
    private boolean initialized = false;
    private Schema schema;
    private Registry registry;
    private Map<Schema.Attribute, Integer> addRemoveOffsetMap = new HashMap<Schema.Attribute, Integer>();

    @Inject
    public UpdateRequest(Registry registry) {
        this.registry = registry;
    }

    public void initWithResource(String id, T original, T resource) {
        this.id = id;
        this.schema = this.registry.getSchema(original.getBaseUrn());
        this.original = original;
        this.resource = resource;
        this.initialized = true;
    }

    public void initWithPatch(String id, T original, List<PatchOperation> patchOperations) {
        this.id = id;
        this.original = original;
        this.patchOperations = patchOperations;
        this.schema = this.registry.getSchema(original.getBaseUrn());
        this.initialized = true;
    }

    public T getResource() {
        if (!this.initialized) {
            throw new IllegalStateException("UpdateRequest was not initialized");
        }
        if (this.resource != null) {
            return this.resource;
        }
        return this.applyPatchOperations();
    }

    public List<PatchOperation> getPatchOperations() {
        if (!this.initialized) {
            throw new IllegalStateException("UpdateRequest was not initialized");
        }
        if (this.patchOperations == null) {
            try {
                this.patchOperations = this.createPatchOperations();
            }
            catch (JsonProcessingException | IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException("Error creating the patch list", e);
            }
        }
        return this.patchOperations;
    }

    private void sortMultiValuedCollections(Object obj1, Object obj2, AttributeContainer ac) throws IllegalArgumentException, IllegalAccessException {
        for (Schema.Attribute attribute : ac.getAttributes()) {
            Field field = attribute.getField();
            if (attribute.isMultiValued()) {
                List collection1 = obj1 != null ? (List)field.get(obj1) : null;
                List collection2 = obj2 != null ? (List)field.get(obj2) : null;
                Set<Object> priorities = this.findCommonElements(collection1, collection2);
                PrioritySortingComparitor prioritySortingComparitor = new PrioritySortingComparitor(priorities);
                if (collection1 != null) {
                    Collections.sort(collection1, prioritySortingComparitor);
                }
                if (collection2 == null) continue;
                Collections.sort(collection2, prioritySortingComparitor);
                continue;
            }
            if (attribute.getType() != Schema.Attribute.Type.COMPLEX) continue;
            Object nextObj1 = obj1 != null ? field.get(obj1) : null;
            Object nextObj2 = obj2 != null ? field.get(obj2) : null;
            this.sortMultiValuedCollections(nextObj1, nextObj2, (AttributeContainer)attribute);
        }
    }

    private Set<Object> findCommonElements(List<Object> list1, List<Object> list2) {
        if (list1 == null || list2 == null) {
            return Collections.emptySet();
        }
        Set<Object> set1 = new HashSet<Object>(list1);
        Set<Object> set2 = new HashSet<Object>(list2);
        set1 = set1.stream().map(PrioritySortingComparitor::getComparableValue).collect(Collectors.toSet());
        set2 = set2.stream().map(PrioritySortingComparitor::getComparableValue).collect(Collectors.toSet());
        set1.retainAll(set2);
        return set1;
    }

    private T applyPatchOperations() {
        throw new UnsupportedOperationException("PATCH operations are not implemented at this time.");
    }

    private static void nullEmptyLists(JsonNode node) {
        ArrayList<String> objectsToDelete = new ArrayList<String>();
        if (node != null) {
            Iterator children = node.fields();
            while (children.hasNext()) {
                ArrayNode ar;
                Map.Entry child = (Map.Entry)children.next();
                String name = (String)child.getKey();
                JsonNode childNode = (JsonNode)child.getValue();
                if (childNode.isContainerNode()) {
                    UpdateRequest.nullEmptyLists(childNode);
                }
                if (!(childNode instanceof ArrayNode) || (ar = (ArrayNode)childNode).size() != 0) continue;
                objectsToDelete.add(name);
            }
            if (!objectsToDelete.isEmpty() && node instanceof ObjectNode) {
                ObjectNode on = (ObjectNode)node;
                for (String name : objectsToDelete) {
                    on.putNull(name);
                }
            }
        }
    }

    private List<PatchOperation> createPatchOperations() throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        this.sortMultiValuedCollections(this.original, this.resource, (AttributeContainer)this.schema);
        Map originalExtensions = this.original.getExtensions();
        Map resourceExtensions = this.resource.getExtensions();
        HashSet keys = new HashSet();
        keys.addAll(originalExtensions.keySet());
        keys.addAll(resourceExtensions.keySet());
        for (String key : keys) {
            Schema extSchema = this.registry.getSchema(key);
            ScimExtension originalExtension = (ScimExtension)originalExtensions.get(key);
            ScimExtension resourceExtension = (ScimExtension)resourceExtensions.get(key);
            this.sortMultiValuedCollections(originalExtension, resourceExtension, (AttributeContainer)extSchema);
        }
        ObjectMapper objMapper = new ObjectMapper();
        JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
        objMapper.registerModule((Module)jaxbAnnotationModule);
        objMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(objMapper.getTypeFactory());
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        AnnotationIntrospectorPair pair = new AnnotationIntrospectorPair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
        objMapper.setAnnotationIntrospector((AnnotationIntrospector)pair);
        JsonNode node1 = objMapper.valueToTree(this.original);
        UpdateRequest.nullEmptyLists(node1);
        JsonNode node2 = objMapper.valueToTree(this.resource);
        UpdateRequest.nullEmptyLists(node2);
        JsonNode differences = JsonDiff.asJson((JsonNode)node1, (JsonNode)node2);
        List<PatchOperation> patchOps = this.convertToPatchOperations(differences);
        return patchOps;
    }

    JsonNode compareUsers(ScimUser user1, ScimUser user2) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node1 = mapper.valueToTree((Object)user1);
        JsonNode node2 = mapper.valueToTree((Object)user2);
        return JsonDiff.asJson((JsonNode)node1, (JsonNode)node2);
    }

    List<PatchOperation> convertToPatchOperations(JsonNode node) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        ArrayList<PatchOperation> operations = new ArrayList<PatchOperation>();
        if (node == null) {
            return Collections.emptyList();
        }
        if (!(node instanceof ArrayNode)) {
            throw new RuntimeException("Expecting an instance of a ArrayNode, but got: " + node.getClass());
        }
        ArrayNode root = (ArrayNode)node;
        for (int i = 0; i < root.size(); ++i) {
            ObjectNode patchNode = (ObjectNode)root.get(i);
            JsonNode operationNode = patchNode.get(OPERATION);
            JsonNode pathNode = patchNode.get(PATH);
            JsonNode valueNode = patchNode.get(VALUE);
            List<PatchOperation> nodeOperations = this.convertNodeToPatchOperations(operationNode.asText(), pathNode.asText(), valueNode);
            if (nodeOperations.isEmpty()) continue;
            operations.addAll(nodeOperations);
        }
        return operations;
    }

    private List<PatchOperation> convertNodeToPatchOperations(String operationNode, String diffPath, JsonNode valueNode) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        log.info(operationNode + ", " + diffPath);
        ArrayList<PatchOperation> operations = new ArrayList<PatchOperation>();
        PatchOperation.Type patchOpType = PatchOperation.Type.valueOf((String)operationNode.toUpperCase());
        if (diffPath != null && diffPath.length() >= 1) {
            ParseData parseData = new ParseData(diffPath);
            if (parseData.pathParts.isEmpty()) {
                operations.add(this.handleExtensions(valueNode, patchOpType, parseData));
            } else {
                operations.addAll(this.handleAttributes(valueNode, patchOpType, parseData));
            }
        }
        return operations;
    }

    private PatchOperation handleExtensions(JsonNode valueNode, PatchOperation.Type patchOpType, ParseData parseData) throws JsonProcessingException {
        PatchOperation operation = new PatchOperation();
        operation.setOperation(patchOpType);
        AttributeReference attributeReference = new AttributeReference(parseData.pathUri, null);
        PatchOperationPath patchOperationPath = new PatchOperationPath();
        ValuePathExpression valuePathExpression = new ValuePathExpression(attributeReference);
        patchOperationPath.setValuePathExpression(valuePathExpression);
        operation.setPath(patchOperationPath);
        operation.setValue(this.determineValue(patchOpType, valueNode, parseData));
        return operation;
    }

    private List<PatchOperation> handleAttributes(JsonNode valueNode, PatchOperation.Type patchOpType, ParseData parseData) throws IllegalAccessException, JsonProcessingException {
        log.info("in handleAttributes");
        ArrayList<PatchOperation> operations = new ArrayList<PatchOperation>();
        ArrayList<String> attributeReferenceList = new ArrayList<String>();
        AttributeComparisonExpression valueFilterExpression = null;
        ArrayList<String> subAttributes = new ArrayList<String>();
        boolean processingMultiValued = false;
        boolean processedMultiValued = false;
        boolean done = false;
        int i = 0;
        for (String pathPart : parseData.pathParts) {
            log.info(pathPart);
            if (done) {
                throw new RuntimeException("Path should be done... Attribute not supported by the schema: " + pathPart);
            }
            if (processingMultiValued) {
                parseData.traverseObjectsInArray(pathPart, patchOpType);
                if (!parseData.isLastIndex(i) || patchOpType != PatchOperation.Type.ADD) {
                    if (parseData.originalObject instanceof TypedAttribute) {
                        TypedAttribute typedAttribute = (TypedAttribute)parseData.originalObject;
                        String type = typedAttribute.getType();
                        valueFilterExpression = new AttributeComparisonExpression(new AttributeReference("type"), CompareOperator.EQ, (Object)type);
                    } else if (parseData.originalObject instanceof String || parseData.originalObject instanceof Number) {
                        String toString = parseData.originalObject.toString();
                        valueFilterExpression = new AttributeComparisonExpression(new AttributeReference(VALUE), CompareOperator.EQ, (Object)toString);
                    } else if (parseData.originalObject instanceof Enum) {
                        Enum tempEnum = (Enum)parseData.originalObject;
                        valueFilterExpression = new AttributeComparisonExpression(new AttributeReference(VALUE), CompareOperator.EQ, (Object)tempEnum.name());
                    } else {
                        log.info("Attribute: {} doesn't implement TypedAttribute, can't create ValueFilterExpression", parseData.originalObject.getClass());
                        valueFilterExpression = new AttributeComparisonExpression(new AttributeReference(VALUE), CompareOperator.EQ, (Object)"?");
                    }
                    processingMultiValued = false;
                    processedMultiValued = true;
                }
            } else {
                Schema.Attribute attribute = parseData.ac.getAttribute(pathPart);
                if (attribute != null) {
                    if (processedMultiValued) {
                        subAttributes.add(pathPart);
                    } else {
                        log.info("Adding " + pathPart + " to attributeReferenceList");
                        attributeReferenceList.add(pathPart);
                    }
                    parseData.traverseObjects(pathPart, attribute);
                    if (patchOpType == PatchOperation.Type.REPLACE && parseData.resourceObject != null && parseData.resourceObject instanceof Collection && !((Collection)parseData.resourceObject).isEmpty() && (parseData.originalObject == null || parseData.originalObject instanceof Collection && ((Collection)parseData.originalObject).isEmpty())) {
                        patchOpType = PatchOperation.Type.ADD;
                    }
                    if (attribute.isMultiValued()) {
                        processingMultiValued = true;
                    } else if (attribute.getType() != Schema.Attribute.Type.COMPLEX) {
                        done = true;
                    }
                }
            }
            ++i;
        }
        if (patchOpType == PatchOperation.Type.REPLACE && (parseData.resourceObject == null || parseData.resourceObject instanceof Collection && ((Collection)parseData.resourceObject).isEmpty())) {
            patchOpType = PatchOperation.Type.REMOVE;
            valueNode = null;
        }
        if (patchOpType == PatchOperation.Type.REPLACE && parseData.originalObject == null) {
            patchOpType = PatchOperation.Type.ADD;
        }
        if (!attributeReferenceList.isEmpty()) {
            Object value = this.determineValue(patchOpType, valueNode, parseData);
            if (value != null && value instanceof ArrayList) {
                List objList = (List)value;
                if (!objList.isEmpty()) {
                    Object firstElement = objList.get(0);
                    if (firstElement instanceof ArrayList) {
                        objList = (List)firstElement;
                    }
                    for (Object obj : objList) {
                        PatchOperation operation = this.buildPatchOperation(patchOpType, parseData, attributeReferenceList, (FilterExpression)valueFilterExpression, subAttributes, obj);
                        if (operation == null) continue;
                        operations.add(operation);
                    }
                }
            } else {
                PatchOperation operation = this.buildPatchOperation(patchOpType, parseData, (List<String>)attributeReferenceList, (FilterExpression)valueFilterExpression, (List<String>)subAttributes, value);
                if (operation != null) {
                    operations.add(operation);
                }
            }
        }
        return operations;
    }

    private PatchOperation buildPatchOperation(PatchOperation.Type patchOpType, ParseData parseData, List<String> attributeReferenceList, FilterExpression valueFilterExpression, List<String> subAttributes, Object value) {
        String subAttribute;
        PatchOperation operation = new PatchOperation();
        operation.setOperation(patchOpType);
        String attribute = attributeReferenceList.get(0);
        String string = subAttribute = attributeReferenceList.size() > 1 ? attributeReferenceList.get(1) : null;
        if (subAttribute == null && !subAttributes.isEmpty()) {
            subAttribute = subAttributes.get(0);
        }
        AttributeReference attributeReference = new AttributeReference(parseData.pathUri, attribute, subAttribute);
        PatchOperationPath patchOperationPath = new PatchOperationPath();
        ValuePathExpression valuePathExpression = new ValuePathExpression(attributeReference, valueFilterExpression);
        patchOperationPath.setValuePathExpression(valuePathExpression);
        operation.setPath(patchOperationPath);
        operation.setValue(value);
        return operation;
    }

    private Object determineValue(PatchOperation.Type patchOpType, JsonNode valueNode, ParseData parseData) throws JsonProcessingException {
        if (patchOpType == PatchOperation.Type.REMOVE) {
            return null;
        }
        if (valueNode != null) {
            if (valueNode instanceof TextNode) {
                return valueNode.asText();
            }
            if (valueNode instanceof BooleanNode) {
                return valueNode.asBoolean();
            }
            if (valueNode instanceof DoubleNode || valueNode instanceof FloatNode) {
                return valueNode.asDouble();
            }
            if (valueNode instanceof IntNode) {
                return valueNode.asInt();
            }
            if (valueNode instanceof NullNode) {
                return null;
            }
            if (valueNode instanceof ObjectNode) {
                return parseData.resourceObject;
            }
            if (valueNode instanceof POJONode) {
                POJONode pojoNode = (POJONode)valueNode;
                return pojoNode.getPojo();
            }
            if (valueNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)valueNode;
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Object subObject = this.determineValue(patchOpType, arrayNode.get(i), parseData);
                    if (subObject == null) continue;
                    objectList.add(subObject);
                }
                return objectList;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateRequest)) {
            return false;
        }
        UpdateRequest other = (UpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        T this$resource = this.getResource();
        T other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        T this$original = this.getOriginal();
        T other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !this$original.equals(other$original)) {
            return false;
        }
        List<PatchOperation> this$patchOperations = this.getPatchOperations();
        List<PatchOperation> other$patchOperations = other.getPatchOperations();
        if (this$patchOperations == null ? other$patchOperations != null : !((Object)this$patchOperations).equals(other$patchOperations)) {
            return false;
        }
        if (this.initialized != other.initialized) {
            return false;
        }
        Schema this$schema = this.schema;
        Schema other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        Registry this$registry = this.registry;
        Registry other$registry = other.registry;
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        Map<Schema.Attribute, Integer> this$addRemoveOffsetMap = this.addRemoveOffsetMap;
        Map<Schema.Attribute, Integer> other$addRemoveOffsetMap = other.addRemoveOffsetMap;
        return !(this$addRemoveOffsetMap == null ? other$addRemoveOffsetMap != null : !((Object)this$addRemoveOffsetMap).equals(other$addRemoveOffsetMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        T $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        T $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : $original.hashCode());
        List<PatchOperation> $patchOperations = this.getPatchOperations();
        result = result * 59 + ($patchOperations == null ? 43 : ((Object)$patchOperations).hashCode());
        result = result * 59 + (this.initialized ? 79 : 97);
        Schema $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        Registry $registry = this.registry;
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        Map<Schema.Attribute, Integer> $addRemoveOffsetMap = this.addRemoveOffsetMap;
        result = result * 59 + ($addRemoveOffsetMap == null ? 43 : ((Object)$addRemoveOffsetMap).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateRequest(id=" + this.getId() + ", resource=" + this.getResource() + ", original=" + this.getOriginal() + ", patchOperations=" + this.getPatchOperations() + ", initialized=" + this.initialized + ", schema=" + this.schema + ", registry=" + this.registry + ", addRemoveOffsetMap=" + this.addRemoveOffsetMap + ")";
    }

    public String getId() {
        return this.id;
    }

    public T getOriginal() {
        return this.original;
    }

    private class ParseData {
        List<String> pathParts;
        Object originalObject;
        Object resourceObject;
        AttributeContainer ac;
        String pathUri;

        public ParseData(String diffPath) {
            String path = diffPath.substring(1);
            this.pathParts = new ArrayList<String>(Arrays.asList(path.split("/")));
            this.pathUri = null;
            String firstPathPart = this.pathParts.get(0);
            if (firstPathPart.contains(":")) {
                this.pathUri = firstPathPart;
                this.pathParts.remove(0);
            }
            if (this.pathUri != null) {
                this.ac = UpdateRequest.this.registry.getSchema(this.pathUri);
                this.originalObject = UpdateRequest.this.original.getExtension(this.pathUri);
                this.resourceObject = UpdateRequest.this.resource.getExtension(this.pathUri);
            } else {
                this.ac = UpdateRequest.this.schema;
                this.originalObject = UpdateRequest.this.original;
                this.resourceObject = UpdateRequest.this.resource;
            }
        }

        public void traverseObjects(String pathPart, Schema.Attribute attribute) throws IllegalArgumentException, IllegalAccessException {
            this.originalObject = this.lookupAttribute(this.originalObject, this.ac, pathPart);
            this.resourceObject = this.lookupAttribute(this.resourceObject, this.ac, pathPart);
            this.ac = attribute;
        }

        public void traverseObjectsInArray(String pathPart, PatchOperation.Type patchOpType) {
            int index = Integer.parseInt(pathPart);
            Schema.Attribute attr = (Schema.Attribute)this.ac;
            Integer addRemoveOffset = UpdateRequest.this.addRemoveOffsetMap.getOrDefault(attr, 0);
            switch (patchOpType) {
                case ADD: {
                    UpdateRequest.this.addRemoveOffsetMap.put(attr, addRemoveOffset - 1);
                    break;
                }
                case REMOVE: {
                    UpdateRequest.this.addRemoveOffsetMap.put(attr, addRemoveOffset + 1);
                    break;
                }
            }
            int newindex = index + addRemoveOffset;
            if (newindex < 0) {
                log.error("Attempting to retrieve a negative index:{} on pathPath: {}", (Object)newindex, (Object)pathPart);
            }
            this.originalObject = this.lookupIndexInArray(this.originalObject, newindex);
            this.resourceObject = this.lookupIndexInArray(this.resourceObject, index);
        }

        public boolean isLastIndex(int index) {
            int numPathParts = this.pathParts.size();
            return index == numPathParts - 1;
        }

        private Object lookupIndexInArray(Object object, int index) {
            if (!(object instanceof List)) {
                throw new RuntimeException("Unsupported collection type: " + object.getClass());
            }
            List list = (List)object;
            if (index >= list.size()) {
                return null;
            }
            return list.get(index);
        }

        private Object lookupAttribute(Object object, AttributeContainer ac, String attributeName) throws IllegalArgumentException, IllegalAccessException {
            if (object == null) {
                return null;
            }
            Schema.Attribute attribute = ac.getAttribute(attributeName);
            Field field = attribute.getField();
            return field.get(object);
        }
    }
}

