/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine.util.pool;

import com.sun.portal.portletcontainer.appengine.util.pool.ObjectManager;
import com.sun.portal.portletcontainer.appengine.util.pool.Pool;
import java.util.ArrayList;
import java.util.List;

public class SimpleObjectPool
implements Pool {
    private ObjectManager objectManager;
    private List objectPool;
    private int minSize;
    private int maxSize;
    private boolean overflow;
    private int leased;
    private int mid;
    private boolean destroyed;

    public SimpleObjectPool(ObjectManager objectManager, int minSize, int maxSize, boolean overflow) {
        this.objectManager = objectManager;
        this.objectPool = new ArrayList(maxSize);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.mid = (this.minSize + this.maxSize) / 2 + 1;
        this.overflow = overflow;
        this.leased = 0;
        this.destroyed = false;
        for (int i = 0; i < this.minSize; ++i) {
            this.objectPool.add(this.objectManager.createObject(null));
        }
    }

    public synchronized Object obtainObject(Object param) {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        Object o = null;
        int size = this.objectPool.size();
        if (size > 0) {
            o = this.objectPool.remove(size - 1);
            ++this.leased;
        } else if (this.leased < this.maxSize || this.overflow) {
            o = this.objectManager.createObject(param);
            ++this.leased;
        }
        return o;
    }

    public synchronized void releaseObject(Object o) {
        --this.leased;
        if (this.destroyed) {
            this.objectManager.destroyObject(o);
        } else {
            this.objectPool.add(o);
            int size = this.objectPool.size();
            int extra = size - this.maxSize;
            if (extra > 0 && this.leased < this.mid) {
                for (int i = 0; i < extra; ++i) {
                    o = this.objectPool.remove(--size);
                    this.objectManager.destroyObject(o);
                }
            }
        }
    }

    public int getLeased() {
        return this.leased;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        this.maxSize = maxSize;
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        this.destroyed = true;
        for (int i = 0; i < this.objectPool.size(); ++i) {
            Object o = this.objectPool.get(i);
            this.objectManager.destroyObject(o);
        }
    }

    public final boolean doesReuseObjects() {
        return true;
    }

    protected void finalize() {
        if (!this.destroyed) {
            this.destroy();
        }
    }
}

