/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.awt.Size;
import com.sun.star.frame.XController;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextContentInserterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTextContentInserterFilter.class);
    private Dimension rectSize;
    private final Map<String, Object> shapeProperties;

    public static @NonNull Map<@NonNull String, @NonNull Object> createDefaultShapeProperties(int horizontalPosition, int verticalPosition) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("AnchorType", TextContentAnchorType.AT_PAGE);
        props.put("HoriOrient", (short)0);
        props.put("HoriOrientPosition", horizontalPosition * 100);
        props.put("HoriOrientRelation", (short)7);
        props.put("VertOrient", (short)0);
        props.put("VertOrientPosition", verticalPosition * 100);
        props.put("VertOrientRelation", (short)7);
        props.put("Surround", WrapTextMode.THROUGHT);
        return props;
    }

    public static Size toOfficeSize(@NonNull Dimension size) {
        return new Size(size.width * 100, size.height * 100);
    }

    public AbstractTextContentInserterFilter(int horizontalPosition, int verticalPosition) {
        this.shapeProperties = AbstractTextContentInserterFilter.createDefaultShapeProperties(horizontalPosition, verticalPosition);
    }

    public AbstractTextContentInserterFilter(@NonNull Map<@NonNull String, @NonNull Object> shapeProperties) {
        AssertUtils.notNull(shapeProperties, (String)"shapeProperties must not be null");
        this.shapeProperties = new LinkedHashMap<String, Object>(shapeProperties);
    }

    public AbstractTextContentInserterFilter(@NonNull Dimension size, int horizontalPosition, int verticalPosition) {
        AssertUtils.notNull((Object)size, (String)"size must not be null");
        this.rectSize = new Dimension(size.width, size.height);
        this.shapeProperties = AbstractTextContentInserterFilter.createDefaultShapeProperties(horizontalPosition, verticalPosition);
    }

    public AbstractTextContentInserterFilter(@NonNull Dimension size, @NonNull Map<@NonNull String, @NonNull Object> shapeProperties) {
        AssertUtils.notNull((Object)size, (String)"size must not be null");
        AssertUtils.notNull(shapeProperties, (String)"shapeProperties must not be null");
        this.rectSize = new Dimension(size.width, size.height);
        this.shapeProperties = new LinkedHashMap<String, Object>(shapeProperties);
    }

    protected void applyAnchorPageNoFix(@NonNull XTextDocument docText, @NonNull XTextCursor textCursor) {
        Object anchorPageNo = this.shapeProperties.get("AnchorPageNo");
        if (anchorPageNo != null) {
            LOGGER.debug("Applying AnchorPageNo fix");
            XController controller = docText.getCurrentController();
            XTextViewCursor viewCursor = Lo.qi(XTextViewCursorSupplier.class, controller).getViewCursor();
            XPageCursor pageCursor = Lo.qi(XPageCursor.class, viewCursor);
            pageCursor.jumpToPage(Short.parseShort(anchorPageNo.toString()));
            textCursor.gotoRange((XTextRange)viewCursor, false);
        }
    }

    public @NonNull Dimension getRectSize() {
        return this.rectSize;
    }

    protected void setRectSize(@NonNull Dimension size) {
        this.rectSize = size;
    }

    public @NonNull Map<@NonNull String, Object> getShapeProperties() {
        return this.shapeProperties;
    }
}

