/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.MembershipWriter;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MembershipProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(MembershipProvider.class);
    private final MembershipWriter writer = new MembershipWriter();

    MembershipProvider(@NotNull Root root, @NotNull ConfigurationParameters config) {
        super(root, config);
    }

    void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.writer.setMembershipSizeThreshold(membershipSizeThreshold);
    }

    @NotNull
    Iterator<Tree> getMembership(@NotNull Tree authorizableTree, boolean includeInherited) {
        return this.getMembership(authorizableTree, includeInherited, new HashSet<String>());
    }

    @NotNull
    private Iterator<Tree> getMembership(@NotNull Tree authorizableTree, boolean includeInherited, @NotNull Set<String> processedPaths) {
        Iterable<Tree> refTrees = this.identifierManager.getReferences(authorizableTree, "rep:members", "rep:MemberReferences", true);
        return new MembershipIterator(refTrees.iterator(), includeInherited, processedPaths);
    }

    private boolean hasMembership(@NotNull Tree authorizableTree, @NotNull String groupPath) {
        return IteratorUtils.contains((Iterator)IteratorUtils.transform(this.getMembership(authorizableTree, true), Tree::getPath), (Object)groupPath);
    }

    @NotNull
    Iterator<Tree> getMembers(@NotNull Tree groupTree, boolean includeInherited) {
        return this.getMembers(groupTree, this.getContentID(groupTree), includeInherited, new HashSet<String>());
    }

    @NotNull
    Iterator<String> getDeclaredMemberContentIDs(@NotNull Tree groupTree) {
        return this.getDeclaredMemberReferenceIterator(groupTree);
    }

    @NotNull
    private Iterator<Tree> getMembers(@NotNull Tree groupTree, final @NotNull String groupContentId, final boolean includeInherited, final @NotNull Set<String> processedRefs) {
        MemberReferenceIterator mrit = new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@NotNull String value) {
                if (groupContentId.equals(value)) {
                    log.error("Cyclic group membership detected for contentId {}", (Object)groupContentId);
                    return false;
                }
                return processedRefs.add(value);
            }
        };
        return new AbstractMemberIterator<String>((Iterator)((Object)mrit)){

            @Override
            protected Tree internalGetNext(@NotNull String value) {
                Tree next = MembershipProvider.this.identifierManager.getTree(PropertyValues.newWeakReference((String)value));
                if (includeInherited && UserUtil.isType((Tree)next, (AuthorizableType)AuthorizableType.GROUP)) {
                    this.remember(next);
                }
                return next;
            }

            @Override
            @NotNull
            protected Iterator<Tree> getNextIterator(@NotNull Tree groupTree) {
                return MembershipProvider.this.getMembers(groupTree, groupContentId, true, processedRefs);
            }
        };
    }

    boolean isMember(@NotNull Tree groupTree, @NotNull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        if (this.pendingChanges(groupTree)) {
            return IteratorUtils.contains((Iterator)IteratorUtils.transform(this.getMembers(groupTree, true), Tree::getPath), (Object)authorizableTree.getPath());
        }
        return this.hasMembership(authorizableTree, groupTree.getPath());
    }

    boolean isDeclaredMember(@NotNull Tree groupTree, @NotNull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        String contentId = this.getContentID(authorizableTree);
        MemberReferenceIterator refs = this.getDeclaredMemberReferenceIterator(groupTree);
        return IteratorUtils.contains((Iterator)((Object)refs), (Object)contentId);
    }

    private static boolean hasMembers(@NotNull Tree groupTree) {
        return groupTree.getPropertyStatus("rep:members") != null || groupTree.hasChild("rep:membersList");
    }

    private boolean pendingChanges(@NotNull Tree groupTree) {
        Tree.Status memberPropStatus = groupTree.getPropertyStatus("rep:members");
        return Tree.Status.UNCHANGED != memberPropStatus || this.root.hasPendingChanges();
    }

    boolean addMember(@NotNull Tree groupTree, @NotNull Tree newMemberTree) {
        return this.writer.addMember(groupTree, this.getContentID(newMemberTree));
    }

    Set<String> addMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        return this.writer.addMembers(groupTree, memberIds);
    }

    boolean removeMember(@NotNull Tree groupTree, @NotNull Tree memberTree) {
        if (this.writer.removeMember(groupTree, this.getContentID(memberTree))) {
            return true;
        }
        log.debug("Authorizable {} was not member of {}", (Object)memberTree.getName(), (Object)groupTree.getName());
        return false;
    }

    Set<String> removeMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        return this.writer.removeMembers(groupTree, memberIds);
    }

    private MemberReferenceIterator getDeclaredMemberReferenceIterator(@NotNull Tree groupTree) {
        return new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@NotNull String value) {
                return true;
            }
        };
    }

    private final class MembershipIterator
    extends AbstractMemberIterator<Tree> {
        private final boolean includeInherited;
        private final Set<String> processedPaths;

        private MembershipIterator(Iterator<Tree> references, @NotNull boolean includeInherited, Set<String> processedPaths) {
            super(references);
            this.includeInherited = includeInherited;
            this.processedPaths = processedPaths;
        }

        @Override
        protected Tree internalGetNext(@NotNull Tree refTree) {
            Tree next = null;
            Tree groupTree = this.getGroupTree(refTree);
            if (groupTree != null) {
                if (this.processedPaths.add(groupTree.getPath())) {
                    next = groupTree;
                    if (this.includeInherited) {
                        this.remember(groupTree);
                    }
                }
            } else {
                log.debug("Not a membership reference {}", (Object)refTree);
            }
            return next;
        }

        @Override
        @NotNull
        protected Iterator<Tree> getNextIterator(@NotNull Tree groupTree) {
            return MembershipProvider.this.getMembership(groupTree, true, this.processedPaths);
        }

        @Nullable
        private Tree getGroupTree(@NotNull Tree tree) {
            Tree groupTree = tree;
            while (!groupTree.isRoot()) {
                String ntName = TreeUtil.getPrimaryTypeName((Tree)groupTree);
                if ("rep:Group".equals(ntName)) {
                    return groupTree;
                }
                groupTree = groupTree.getParent();
            }
            return null;
        }
    }

    private static abstract class AbstractMemberIterator<T>
    extends AbstractLazyIterator<Tree> {
        private final Iterator<T> references;
        private List<Tree> groupTrees;
        private Iterator<Tree> parent;

        AbstractMemberIterator(@NotNull Iterator<T> references) {
            this.references = references;
        }

        protected Tree getNext() {
            Tree next = null;
            while (next == null) {
                if (this.references.hasNext()) {
                    next = this.internalGetNext(this.references.next());
                    continue;
                }
                if (this.parent != null) {
                    if (this.parent.hasNext()) {
                        next = this.parent.next();
                        continue;
                    }
                    this.parent = null;
                    continue;
                }
                if (this.groupTrees == null || this.groupTrees.isEmpty()) break;
                this.parent = this.getNextIterator(this.groupTrees.remove(0));
            }
            return next;
        }

        void remember(@NotNull Tree groupTree) {
            if (this.groupTrees == null) {
                this.groupTrees = new ArrayList<Tree>();
            }
            this.groupTrees.add(groupTree);
        }

        @Nullable
        protected abstract Tree internalGetNext(@NotNull T var1);

        @NotNull
        protected abstract Iterator<Tree> getNextIterator(@NotNull Tree var1);
    }

    private static abstract class MemberReferenceIterator
    extends AbstractLazyIterator<String> {
        private final Iterator<Tree> trees;
        private Iterator<String> propertyValues;

        private MemberReferenceIterator(@NotNull Tree groupTree) {
            this.trees = IteratorUtils.chainedIterator(Collections.singleton(groupTree).iterator(), groupTree.getChild("rep:membersList").getChildren().iterator());
        }

        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.propertyValues == null) {
                    if (!this.trees.hasNext()) break;
                    PropertyState property = this.trees.next().getProperty("rep:members");
                    if (property == null) continue;
                    this.propertyValues = ((Iterable)property.getValue(Type.STRINGS)).iterator();
                    continue;
                }
                if (!this.propertyValues.hasNext()) {
                    this.propertyValues = null;
                    continue;
                }
                String value = this.propertyValues.next();
                if (!this.hasProcessedReference(value)) continue;
                next = value;
            }
            return next;
        }

        protected abstract boolean hasProcessedReference(@NotNull String var1);
    }
}

