/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.ParsedDirective;
import com.novell.security.sasl.SaslException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

class DirectiveList {
    private static final int STATE_LOOKING_FOR_FIRST_DIRECTIVE = 1;
    private static final int STATE_LOOKING_FOR_DIRECTIVE = 2;
    private static final int STATE_SCANNING_NAME = 3;
    private static final int STATE_LOOKING_FOR_EQUALS = 4;
    private static final int STATE_LOOKING_FOR_VALUE = 5;
    private static final int STATE_LOOKING_FOR_COMMA = 6;
    private static final int STATE_SCANNING_QUOTED_STRING_VALUE = 7;
    private static final int STATE_SCANNING_TOKEN_VALUE = 8;
    private static final int STATE_NO_UTF8_SUPPORT = 9;
    private int m_curPos = 0;
    private int m_errorPos = -1;
    private String m_directives;
    private int m_state = 1;
    private ArrayList m_directiveList = new ArrayList(10);
    private String m_curName;
    private int m_scanStart = 0;

    DirectiveList(byte[] directives) {
        try {
            this.m_directives = new String(directives, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.m_state = 9;
        }
    }

    void parseDirectives() throws SaslException {
        boolean rc = false;
        boolean haveQuotedPair = false;
        String currentName = "<no name>";
        if (this.m_state == 9) {
            throw new SaslException("No UTF-8 support on platform");
        }
        char prevChar = '\u0000';
        while (this.m_curPos < this.m_directives.length()) {
            char currChar = this.m_directives.charAt(this.m_curPos);
            switch (this.m_state) {
                case 1: 
                case 2: {
                    if (this.isWhiteSpace(currChar)) break;
                    if (this.isValidTokenChar(currChar)) {
                        this.m_scanStart = this.m_curPos;
                        this.m_state = 3;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid name character");
                }
                case 3: {
                    if (this.isValidTokenChar(currChar)) break;
                    if (this.isWhiteSpace(currChar)) {
                        currentName = this.m_directives.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 4;
                        break;
                    }
                    if ('=' == currChar) {
                        currentName = this.m_directives.substring(this.m_scanStart, this.m_curPos);
                        this.m_state = 5;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid name character");
                }
                case 4: {
                    if (this.isWhiteSpace(currChar)) break;
                    if ('=' == currChar) {
                        this.m_state = 5;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Expected equals sign '='.");
                }
                case 5: {
                    if (this.isWhiteSpace(currChar)) break;
                    if ('\"' == currChar) {
                        this.m_scanStart = this.m_curPos + 1;
                        this.m_state = 7;
                        break;
                    }
                    if (this.isValidTokenChar(currChar)) {
                        this.m_scanStart = this.m_curPos;
                        this.m_state = 8;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Unexpected character");
                }
                case 8: {
                    if (this.isValidTokenChar(currChar)) break;
                    if (this.isWhiteSpace(currChar)) {
                        this.addDirective(currentName, false);
                        this.m_state = 6;
                        break;
                    }
                    if (',' == currChar) {
                        this.addDirective(currentName, false);
                        this.m_state = 2;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Invalid value character");
                }
                case 7: {
                    if ('\\' == currChar) {
                        haveQuotedPair = true;
                    }
                    if ('\"' != currChar || '\\' == prevChar) break;
                    this.addDirective(currentName, haveQuotedPair);
                    haveQuotedPair = false;
                    this.m_state = 6;
                    break;
                }
                case 6: {
                    if (this.isWhiteSpace(currChar)) break;
                    if (currChar == ',') {
                        this.m_state = 2;
                        break;
                    }
                    this.m_errorPos = this.m_curPos;
                    throw new SaslException("Parse error: Expected a comma.");
                }
            }
            if (rc) break;
            prevChar = currChar;
            ++this.m_curPos;
        }
        if (!rc) {
            switch (this.m_state) {
                case 8: {
                    this.addDirective(currentName, false);
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: {
                    throw new SaslException("Parse error: Trailing comma.");
                }
                case 3: 
                case 4: 
                case 5: {
                    throw new SaslException("Parse error: Missing value.");
                }
                case 7: {
                    throw new SaslException("Parse error: Missing closing quote.");
                }
            }
        }
    }

    boolean isValidTokenChar(char c) {
        return !(c >= '\u0000' && c <= ' ' || c >= ':' && c <= '@' || c >= '[' && c <= ']' || ',' == c || '%' == c || '(' == c || ')' == c || '{' == c || '}' == c) && '\u007f' != c;
    }

    boolean isWhiteSpace(char c) {
        return '\t' == c || '\n' == c || '\r' == c || ' ' == c;
    }

    void addDirective(String name, boolean haveQuotedPair) {
        String value;
        if (!haveQuotedPair) {
            value = this.m_directives.substring(this.m_scanStart, this.m_curPos);
        } else {
            StringBuffer valueBuf = new StringBuffer(this.m_curPos - this.m_scanStart);
            int valueIndex = 0;
            for (int inputIndex = this.m_scanStart; inputIndex < this.m_curPos; ++inputIndex) {
                char valueChar = this.m_directives.charAt(inputIndex);
                if ('\\' == valueChar) {
                    ++inputIndex;
                }
                valueBuf.setCharAt(valueIndex, this.m_directives.charAt(inputIndex));
                ++valueIndex;
            }
            value = new String(valueBuf);
        }
        int type = this.m_state == 7 ? 1 : 2;
        this.m_directiveList.add(new ParsedDirective(name, value, type));
    }

    Iterator getIterator() {
        return this.m_directiveList.iterator();
    }
}

