/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LDAPRestoreRequest
extends LDAPExtendedOperation {
    public LDAPRestoreRequest(String objectDN, byte[] passwd, int bufferLength, String chunkSizesString, byte[] returnedBuffer) throws LDAPException {
        super("2.16.840.1.113719.1.27.100.98", null);
        try {
            int chunkSize;
            if (objectDN == null || bufferLength == 0 || chunkSizesString == null || returnedBuffer == null) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            if (passwd == null) {
                passwd = "".getBytes("UTF8");
            }
            int[] chunks = null;
            int index = chunkSizesString.indexOf(59);
            try {
                chunkSize = Integer.parseInt(chunkSizesString.substring(0, index));
            }
            catch (NumberFormatException e) {
                throw new LDAPLocalException("Invalid data buffer send in the request", 83);
            }
            if (chunkSize == 0) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            chunkSizesString = chunkSizesString.substring(index + 1);
            chunks = new int[chunkSize];
            for (int i = 0; i < chunkSize; ++i) {
                int chunkIndex = chunkSizesString.indexOf(59);
                if (chunkIndex == -1) {
                    chunks[i] = Integer.parseInt(chunkSizesString);
                    break;
                }
                chunks[i] = Integer.parseInt(chunkSizesString.substring(0, chunkIndex));
                chunkSizesString = chunkSizesString.substring(chunkIndex + 1);
            }
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1OctetString asn1_objectDN = new ASN1OctetString(objectDN);
            ASN1OctetString asn1_passwd = new ASN1OctetString(passwd);
            ASN1Integer asn1_bufferLength = new ASN1Integer(bufferLength);
            ASN1OctetString asn1_buffer = new ASN1OctetString(returnedBuffer);
            ASN1Sequence asn1_chunksSeq = new ASN1Sequence();
            asn1_chunksSeq.add(new ASN1Integer(chunkSize));
            ASN1Set asn1_chunksSet = new ASN1Set();
            for (int i = 0; i < chunkSize; ++i) {
                ASN1Integer tmpChunk = new ASN1Integer(chunks[i]);
                ASN1Sequence tmpSeq = new ASN1Sequence();
                tmpSeq.add(tmpChunk);
                asn1_chunksSet.add(tmpSeq);
            }
            asn1_chunksSeq.add(asn1_chunksSet);
            asn1_objectDN.encode(encoder, encodedData);
            asn1_passwd.encode(encoder, encodedData);
            asn1_bufferLength.encode(encoder, encodedData);
            asn1_buffer.encode(encoder, encodedData);
            asn1_chunksSeq.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }
}

