/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.LDAPEventListener;
import com.novell.ldap.events.LDAPEventSource;
import com.novell.ldap.events.LDAPExceptionEvent;
import com.novell.ldap.events.edir.EdirEventIntermediateResponse;
import com.novell.ldap.events.edir.EdirEventSpecifier;
import com.novell.ldap.events.edir.MonitorEventRequest;
import com.novell.ldap.events.edir.MonitorFilterEventRequest;

public class EdirEventSource
extends LDAPEventSource {
    static /* synthetic */ Class class$com$novell$ldap$events$edir$EdirEventIntermediateResponse;

    public EdirEventSource() throws LDAPException {
        this.registerIntermediateResponses();
    }

    public void removeListener(LDAPEventListener alistener) throws LDAPException {
        if (alistener == null) {
            throw new IllegalArgumentException("No parameter can be Null.");
        }
        super.stopeventpolling(alistener);
    }

    public final void registerforEvent(EdirEventSpecifier[] specifier, LDAPConnection conn, LDAPEventListener alistener) throws LDAPException {
        if (specifier == null || conn == null || alistener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        MonitorEventRequest requestoperation = new MonitorEventRequest(specifier);
        this.sendExtendedRequest(conn, requestoperation, alistener);
    }

    private void sendExtendedRequest(LDAPConnection conn, LDAPExtendedOperation requestoperation, LDAPEventListener alistener) throws LDAPException {
        LDAPResponseQueue queue = conn.extendedOperation(requestoperation, null, null);
        EdirEventsGenerator eventgenerator = null;
        int[] ids = queue.getMessageIDs();
        if (ids.length != 1) {
            throw new LDAPException(null, 82, "Unable to Obtain Message Id");
        }
        eventgenerator = new EdirEventsGenerator(alistener);
        super.pollforevents(queue, conn, eventgenerator, ids[0], this);
    }

    public final void registerforFilterEvent(EdirEventSpecifier[] specifier, LDAPConnection conn, LDAPEventListener alistener) throws LDAPException {
        if (specifier == null || conn == null || alistener == null) {
            throw new IllegalArgumentException("Null argument specified");
        }
        MonitorFilterEventRequest requestoperation = new MonitorFilterEventRequest(specifier);
        this.sendExtendedRequest(conn, requestoperation, alistener);
    }

    private void registerIntermediateResponses() throws LDAPException {
        try {
            this.getClass().getClassLoader().loadClass((class$com$novell$ldap$events$edir$EdirEventIntermediateResponse == null ? (class$com$novell$ldap$events$edir$EdirEventIntermediateResponse = EdirEventSource.class$("com.novell.ldap.events.edir.EdirEventIntermediateResponse")) : class$com$novell$ldap$events$edir$EdirEventIntermediateResponse).getName());
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("PARAM_ERROR", 82, e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EdirEventsGenerator
    implements LDAPEventListener {
        private final LDAPEventListener listener;

        EdirEventsGenerator(LDAPEventListener delegatelistener) {
            this.listener = delegatelistener;
        }

        public void ldapEventNotification(LDAPEvent evt) {
            LDAPMessage message;
            evt.setEventclassification(1);
            if (evt.getContainedEventInformation().getType() == 25 && (message = evt.getContainedEventInformation()) instanceof EdirEventIntermediateResponse) {
                EdirEventIntermediateResponse responseintermediate = (EdirEventIntermediateResponse)message;
                evt.setEventtype(responseintermediate.getEventtype());
            }
            this.listener.ldapEventNotification(evt);
        }

        public void ldapExceptionNotification(LDAPExceptionEvent ldapevt) {
            this.listener.ldapExceptionNotification(ldapevt);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

