/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.controls;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.client.Debug;
import java.io.IOException;

public class LDAPPagedResultsResponse
extends LDAPControl {
    private int resultSize;
    private byte[] Cookie;

    public LDAPPagedResultsResponse(String oid, boolean critical, byte[] values) throws IOException {
        super(oid, critical, values);
        LBERDecoder decoder = new LBERDecoder();
        if (decoder == null) {
            throw new IOException("Decoding error");
        }
        ASN1Object asnObj = decoder.decode(values);
        if (asnObj == null || !(asnObj instanceof ASN1Sequence)) {
            throw new IOException("Decoding error");
        }
        Debug.trace("Controls", "LDAPPagedResultsResponse Control Value =" + asnObj.toString());
        ASN1Object asn1resultSize = ((ASN1Sequence)asnObj).get(0);
        if (asn1resultSize == null || !(asn1resultSize instanceof ASN1Integer)) {
            throw new IOException("Decoding error");
        }
        this.resultSize = ((ASN1Integer)asn1resultSize).intValue();
        ASN1Object asn1cookie = ((ASN1Sequence)asnObj).get(1);
        if (asn1cookie == null || !(asn1cookie instanceof ASN1OctetString)) {
            throw new IOException("Decoding error");
        }
        this.Cookie = ((ASN1OctetString)asn1cookie).byteValue();
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public byte[] getCookie() {
        return this.Cookie.length == 0 ? null : this.Cookie;
    }
}

