/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.DSMLSearchResults;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.SPMLSearchResults;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.spml.SPMLImpl;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.DN;
import com.novell.ldap.util.HttpRequestCallback;
import com.novell.ldap.util.RDN;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.openspml.client.SpmlClient;
import org.openspml.message.AddRequest;
import org.openspml.message.Attribute;
import org.openspml.message.FilterTerm;
import org.openspml.message.Identifier;
import org.openspml.message.Modification;
import org.openspml.message.ModifyRequest;
import org.openspml.message.ModifyResponse;
import org.openspml.message.SearchRequest;
import org.openspml.message.SearchResponse;
import org.openspml.message.SpmlRequest;
import org.openspml.message.SpmlResponse;
import org.openspml.util.SpmlException;

public class SPMLConnection
extends LDAPConnection {
    public static final String DEF_IMPL = "com.novell.ldap.spml.SunIdm";
    SpmlClient con;
    SPMLImpl vendorImpl;
    String serverString;
    String binddn;
    String pass;
    boolean isBound;
    boolean isConnected;
    private String host;
    HttpRequestCallback callback;
    static /* synthetic */ Class class$org$openspml$message$Identifier;

    private LDAPMessage sendMessage(LDAPMessage message) throws LDAPException {
        return null;
    }

    private DSMLSearchResults execQuery(LDAPMessage message) throws LDAPException {
        return null;
    }

    public SPMLConnection() {
        this.loadImpl(DEF_IMPL, null);
    }

    public SPMLConnection(String className) {
        this.loadImpl(className, null);
    }

    public SPMLConnection(String className, ClassLoader loader) {
        this.loadImpl(className, loader);
    }

    public SPMLConnection(LDAPSocketFactory factory) {
        this();
    }

    private void loadImpl(String className, ClassLoader loader) {
        SPMLImpl impl = null;
        if (loader == null) {
            try {
                impl = (SPMLImpl)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            impl = (SPMLImpl)loader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            return;
        }
        this.vendorImpl = impl;
        this.con = impl.getSpmlClient();
    }

    public void connect(String serverUrl, int port) throws LDAPException {
        this.serverString = serverUrl;
        this.host = serverUrl.substring(serverUrl.indexOf("//") + 2, serverUrl.indexOf("/", serverUrl.indexOf("//") + 2));
        try {
            this.con.setUrl(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new LDAPLocalException(e.toString(), 53, e);
        }
        this.isConnected = true;
    }

    public void bind(int arg0, String binddn, byte[] pass, LDAPConstraints arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public LDAPResponseQueue bind(int arg0, String arg1, byte[] arg2, LDAPResponseQueue arg3, LDAPConstraints arg4) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue bind(int arg0, String arg1, byte[] arg2, LDAPResponseQueue arg3) throws LDAPException {
        return null;
    }

    public void bind(int arg0, String binddn, byte[] pass) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(int arg0, String binddn, String pass, LDAPConstraints arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(int arg0, String binddn, String pass) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, LDAPConstraints arg2) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, Map arg2, Object arg3, LDAPConstraints arg4) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, Map arg2, Object arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, String[] arg2, Map arg3, Object arg4, LDAPConstraints arg5) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String arg1, String[] arg2, Map arg3, Object arg4) throws LDAPException {
        this.bind(binddn, new String(this.pass));
    }

    public void bind(String binddn, String password) throws LDAPException {
        if (this.isBound) {
            this.vendorImpl.logout();
        }
        this.isBound = false;
        this.vendorImpl.login(binddn, password);
        this.isBound = true;
    }

    public void add(LDAPEntry entry, LDAPConstraints cont) throws LDAPException {
        AddRequest add = new AddRequest();
        DN dn = new DN(entry.getDN());
        RDN rdn = (RDN)dn.getRDNs().get(0);
        Identifier id = new Identifier();
        try {
            id.setType(this.getIdentifierType(rdn.getType()));
        }
        catch (IllegalArgumentException e1) {
            throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
        }
        catch (IllegalAccessException e1) {
            throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
        }
        id.setId(rdn.getValue());
        String objectClass = entry.getAttribute("objectClass").getStringValue();
        add.setObjectClass(objectClass);
        Iterator it = entry.getAttributeSet().iterator();
        HashMap map = new HashMap();
        while (it.hasNext()) {
            LDAPAttribute attrib = (LDAPAttribute)it.next();
            if (attrib.getName().toLowerCase().equals("objectclass")) continue;
            String[] vals = attrib.getStringValueArray();
            ArrayList<String> list = new ArrayList<String>();
            int m = vals.length;
            for (int i = 0; i < m; ++i) {
                list.add(vals[i]);
            }
            map.put(attrib.getName(), list);
        }
        add.setAttributes(map);
        add.setIdentifier(id);
        try {
            SpmlResponse resp = this.con.request((SpmlRequest)add);
            if (resp.getResult().equals("urn:oasis:names:tc:SPML:1:0#pending")) {
                String res = "";
                List attrs = resp.getOperationalAttributes();
                it = attrs.iterator();
                while (it.hasNext()) {
                    Attribute attr = (Attribute)it.next();
                    res = res + "[" + attr.getName() + "=" + attr.getValue() + "] ";
                }
                throw new LDAPLocalException(res, 0);
            }
            if (!resp.getResult().equals("urn:oasis:names:tc:SPML:1:0#success")) {
                System.out.println("Response : " + resp.getResult());
                throw new LDAPLocalException(resp.getErrorMessage(), 53);
            }
        }
        catch (SpmlException e) {
            throw new LDAPException(e.toString(), 53, e.toString());
        }
    }

    public LDAPResponseQueue add(LDAPEntry arg0, LDAPResponseQueue arg1, LDAPConstraints arg2) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue add(LDAPEntry arg0, LDAPResponseQueue arg1) throws LDAPException {
        return null;
    }

    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, (LDAPConstraints)null);
    }

    public void modify(String dn, LDAPModification mod, LDAPConstraints consts) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, consts);
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification arg1, LDAPResponseQueue arg2, LDAPConstraints arg3) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification arg1, LDAPResponseQueue arg2) throws LDAPException {
        return null;
    }

    public void modify(String dn, LDAPModification mod) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, (LDAPConstraints)null);
    }

    public void modify(String dn, LDAPModification[] mods, LDAPConstraints consts) throws LDAPException {
        LDAPControl[] controls = consts != null ? consts.getControls() : null;
        ModifyRequest modreq = new ModifyRequest();
        DN dnVal = new DN(dn);
        RDN rdn = (RDN)dnVal.getRDNs().get(0);
        Identifier id = new Identifier();
        try {
            id.setType(this.getIdentifierType(rdn.getType()));
        }
        catch (IllegalArgumentException e1) {
            throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
        }
        catch (IllegalAccessException e1) {
            throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
        }
        modreq.setIdentifier(id);
        id.setId(rdn.getValue());
        Modification mod = null;
        int m = mods.length;
        for (int i = 0; i < m; ++i) {
            mod = new Modification();
            mod.setName(mods[i].getAttribute().getName());
            ArrayList list = new ArrayList();
            Enumeration evals = mods[i].getAttribute().getStringValues();
            while (evals.hasMoreElements()) {
                list.add(evals.nextElement());
            }
            mod.setValue(list);
            int op = mods[i].getOp();
            switch (op) {
                case 0: {
                    mod.setOperation("add");
                    break;
                }
                case 2: {
                    mod.setOperation("replace");
                    break;
                }
                case 1: {
                    mod.setOperation("delete");
                }
            }
            modreq.addModification(mod);
        }
        try {
            ModifyResponse resp = (ModifyResponse)this.con.request((SpmlRequest)modreq);
            if (!resp.getResult().equals("urn:oasis:names:tc:SPML:1:0#success")) {
                throw new LDAPLocalException(resp.getErrorMessage(), 53);
            }
        }
        catch (SpmlException e) {
            throw new LDAPException(e.toString(), 53, e.toString());
        }
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification[] arg1, LDAPResponseQueue arg2, LDAPConstraints arg3) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification[] arg1, LDAPResponseQueue arg2) throws LDAPException {
        return null;
    }

    public void modify(String dn, LDAPModification[] mods) throws LDAPException {
        this.modify(dn, mods, (LDAPConstraints)null);
    }

    public void rename(String dn, String newDn, boolean delOld, LDAPConstraints consts) throws LDAPException {
        this.rename(dn, newDn, "", delOld, consts);
    }

    public LDAPResponseQueue rename(String arg0, String arg1, boolean arg2, LDAPResponseQueue arg3, LDAPConstraints arg4) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String arg0, String arg1, boolean arg2, LDAPResponseQueue arg3) throws LDAPException {
        return null;
    }

    public void rename(String dn, String newDn, boolean delOld) throws LDAPException {
        this.rename(dn, newDn, "", delOld, (LDAPConstraints)null);
    }

    public void rename(String dn, String newRdn, String newParentDN, boolean delOld, LDAPConstraints constr) throws LDAPException {
        LDAPControl[] controls = constr != null ? constr.getControls() : null;
        LDAPModifyDNRequest msg = new LDAPModifyDNRequest(dn, newRdn, newParentDN, delOld, controls);
        this.sendMessage(msg);
    }

    public LDAPResponseQueue rename(String arg0, String arg1, String arg2, boolean arg3, LDAPResponseQueue arg4, LDAPConstraints arg5) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String arg0, String arg1, String arg2, boolean arg3, LDAPResponseQueue arg4) throws LDAPException {
        return null;
    }

    public void rename(String dn, String newRdn, String newParentDN, boolean delOld) throws LDAPException {
        this.rename(dn, newRdn, newParentDN, delOld, (LDAPConstraints)null);
    }

    public void delete(String dn, LDAPConstraints consts) throws LDAPException {
        LDAPControl[] controls = consts != null ? consts.getControls() : null;
        LDAPDeleteRequest msg = new LDAPDeleteRequest(dn, controls);
        this.sendMessage(msg);
    }

    public LDAPResponseQueue delete(String arg0, LDAPResponseQueue arg1, LDAPConstraints arg2) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue delete(String arg0, LDAPResponseQueue arg1) throws LDAPException {
        return null;
    }

    public void delete(String dn) throws LDAPException {
        this.delete(dn, (LDAPConstraints)null);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchConstraints cons) throws LDAPException {
        SearchResponse res;
        LDAPControl[] controls = cons != null ? cons.getControls() : null;
        LDAPSearchRequest msg = new LDAPSearchRequest(base, scope, filter, attrs, 0, 0, 0, typesOnly, controls);
        SearchRequest req = new SearchRequest();
        if (base != null && base.trim().length() != 0) {
            DN dn = new DN(base);
            if (!(base.toLowerCase().startsWith("ou") || base.toLowerCase().startsWith("dc") || base.toLowerCase().startsWith("o"))) {
                if (scope == 0) {
                    Identifier id = new Identifier();
                    try {
                        id.setType(this.getIdentifierType(((RDN)dn.getRDNs().get(0)).getType()));
                    }
                    catch (IllegalArgumentException e1) {
                        throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
                    }
                    catch (IllegalAccessException e1) {
                        throw new LDAPException("Could not determine type", 53, e1.toString(), e1);
                    }
                    id.setId(dn.explodeDN(true)[0]);
                    req.setSearchBase(id);
                } else {
                    req.setSearchBase(base);
                }
            } else if (scope == 0) {
                return new SPMLSearchResults(new ArrayList());
            }
        }
        if (filter != null && !filter.trim().equalsIgnoreCase("objectClass=*") && !filter.trim().equalsIgnoreCase("(objectClass=*)")) {
            RfcFilter rfcFilter = new RfcFilter(filter.trim());
            FilterTerm filterPart = new FilterTerm();
            System.out.println("part : " + filterPart.getOperation());
            this.stringFilter(rfcFilter.getFilterIterator(), filterPart);
            req.addFilterTerm(filterPart);
        }
        int m = attrs.length;
        for (int i = 0; i < m; ++i) {
            req.addAttribute(attrs[i]);
        }
        try {
            res = this.con.searchRequest(req);
        }
        catch (SpmlException e) {
            throw new LDAPException("Could not search", 53, e.toString());
        }
        return new SPMLSearchResults(res.getResults() != null ? res.getResults() : new ArrayList());
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue, LDAPSearchConstraints cons) throws LDAPException {
        return null;
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue) throws LDAPException {
        return null;
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, (LDAPSearchConstraints)null);
    }

    public boolean isConnectionAlive() {
        return true;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isTLS() {
        return this.serverString.toLowerCase().startsWith("https");
    }

    public void disconnect() throws LDAPException {
        this.serverString = null;
        this.isConnected = false;
    }

    public void disconnect(LDAPConstraints cons) throws LDAPException {
        this.disconnect();
    }

    public LDAPMessageQueue sendRequest(LDAPMessage request, LDAPMessageQueue queue) throws LDAPException {
        this.sendMessage(request);
        return null;
    }

    public HttpRequestCallback getCallback() {
        return this.callback;
    }

    public void setCallback(HttpRequestCallback call) {
        this.callback = call;
    }

    public String getBinddn() {
        return this.binddn;
    }

    public HttpClient getCon() {
        return null;
    }

    public String getHost() {
        return this.host;
    }

    public String getPass() {
        return this.pass;
    }

    public String getServerString() {
        return this.serverString;
    }

    private String getIdentifierType(String rdnAttrib) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = (class$org$openspml$message$Identifier == null ? (class$org$openspml$message$Identifier = SPMLConnection.class$("org.openspml.message.Identifier")) : class$org$openspml$message$Identifier).getFields();
        int m = fields.length;
        for (int i = 0; i < m; ++i) {
            if (!fields[i].getName().startsWith("TYPE") || !fields[i].get(null).toString().endsWith(rdnAttrib)) continue;
            return fields[i].get(null).toString();
        }
        return "";
    }

    private static String byteString(byte[] value) {
        String toReturn = null;
        if (Base64.isValidUTF8(value, true)) {
            try {
                toReturn = new String(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Default JVM does not support UTF-8 encoding" + e);
            }
        } else {
            StringBuffer binary = new StringBuffer();
            for (int i = 0; i < value.length; ++i) {
                if (value[i] >= 0) {
                    binary.append("\\0");
                    binary.append(Integer.toHexString(value[i]));
                    continue;
                }
                binary.append("\\" + Integer.toHexString(value[i]).substring(6));
            }
            toReturn = binary.toString();
        }
        return toReturn;
    }

    private void stringFilter(Iterator itr, FilterTerm filter) {
        int op = -1;
        Object comp = null;
        boolean doAdd = false;
        boolean isFirst = true;
        while (itr.hasNext()) {
            Object filterpart = itr.next();
            if (filterpart instanceof Integer) {
                op = (Integer)filterpart;
                switch (op) {
                    case 0: {
                        if (filter.getOperation() != null) {
                            FilterTerm andFilter = new FilterTerm();
                            andFilter.setOperation("and");
                            filter.addOperand(andFilter);
                            filter = andFilter;
                            break;
                        }
                        filter.setOperation("and");
                        break;
                    }
                    case 1: {
                        if (filter.getOperation() != null) {
                            FilterTerm orFilter = new FilterTerm();
                            orFilter.setOperation("or");
                            filter.addOperand(orFilter);
                            filter = orFilter;
                            break;
                        }
                        if (filter.getOperation() != null) break;
                        filter.setOperation("or");
                        break;
                    }
                    case 2: {
                        if (filter.getOperation() != null) {
                            FilterTerm notFilter = new FilterTerm();
                            notFilter.setOperation("not");
                            filter.addOperand(notFilter);
                            filter = notFilter;
                            break;
                        }
                        filter.setOperation("not");
                        break;
                    }
                    case 3: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("equalityMatch");
                        byte[] value = (byte[])itr.next();
                        part.setValue((Object)SPMLConnection.byteString(value));
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 5: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("greaterOrEqual");
                        byte[] value = (byte[])itr.next();
                        part.setValue((Object)SPMLConnection.byteString(value));
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 6: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("lessOrEqual");
                        byte[] value = (byte[])itr.next();
                        part.setValue((Object)SPMLConnection.byteString(value));
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 7: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("present");
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 8: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("approxMatch");
                        byte[] value = (byte[])itr.next();
                        part.setValue((Object)SPMLConnection.byteString(value));
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 9: {
                        FilterTerm part;
                        String oid = (String)itr.next();
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next() + ":" + oid);
                        part.setOperation("extensibleMatch");
                        byte[] value = (byte[])itr.next();
                        part.setValue((Object)SPMLConnection.byteString(value));
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                    case 4: {
                        FilterTerm part;
                        if (filter.getOperation() == null) {
                            part = filter;
                        } else {
                            part = new FilterTerm();
                            doAdd = true;
                        }
                        part.setName((String)itr.next());
                        part.setOperation("substrings");
                        boolean noStarLast = false;
                        while (itr.hasNext()) {
                            op = (Integer)itr.next();
                            switch (op) {
                                case 0: {
                                    filter.addSubstring((String)itr.next());
                                    noStarLast = false;
                                    break;
                                }
                                case 1: {
                                    filter.addSubstring((String)itr.next());
                                    noStarLast = false;
                                    break;
                                }
                                case 2: {
                                    filter.addSubstring((String)itr.next());
                                }
                            }
                        }
                        if (!doAdd) break;
                        filter.addOperand(part);
                        break;
                    }
                }
                continue;
            }
            if (!(filterpart instanceof Iterator)) continue;
            this.stringFilter((Iterator)filterpart, filter);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

