/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcModifyRequest;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPModifyRequest
extends LDAPMessage {
    public LDAPModifyRequest() {
        super(6);
    }

    public LDAPModifyRequest(String dn, LDAPModification[] mods, LDAPControl[] cont) throws LDAPException {
        super(6, new RfcModifyRequest(new RfcLDAPDN(dn), LDAPModifyRequest.encodeModifications(mods)), cont);
    }

    private static final ASN1SequenceOf encodeModifications(LDAPModification[] mods) {
        ASN1SequenceOf rfcMods = new ASN1SequenceOf(mods.length);
        for (int i = 0; i < mods.length; ++i) {
            LDAPAttribute attr = mods[i].getAttribute();
            ASN1SetOf vals = new ASN1SetOf(attr.size());
            if (attr.size() > 0) {
                Enumeration attrEnum = attr.getByteValues();
                while (attrEnum.hasMoreElements()) {
                    vals.add(new RfcAttributeValue((byte[])attrEnum.nextElement()));
                }
            }
            ASN1Sequence rfcMod = new ASN1Sequence(2);
            rfcMod.add(new ASN1Enumerated(mods[i].getOp()));
            rfcMod.add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(attr.getName()), vals));
            rfcMods.add(rfcMod);
        }
        return rfcMods;
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public LDAPModification[] getModifications() {
        RfcModifyRequest req = (RfcModifyRequest)this.getASN1Object().getRequest();
        ASN1SequenceOf seqof = req.getModifications();
        ASN1Object[] mods = seqof.toArray();
        LDAPModification[] modifications = new LDAPModification[mods.length];
        for (int m = 0; m < mods.length; ++m) {
            ASN1Sequence opSeq = (ASN1Sequence)mods[m];
            if (opSeq.size() != 2) {
                throw new RuntimeException("LDAPModifyRequest: modification " + m + " is wrong size: " + opSeq.size());
            }
            ASN1Object[] opArray = opSeq.toArray();
            ASN1Enumerated asn1op = (ASN1Enumerated)opArray[0];
            int op = asn1op.intValue();
            ASN1Sequence attrSeq = (ASN1Sequence)opArray[1];
            ASN1Object[] attrArray = attrSeq.toArray();
            RfcAttributeDescription aname = (RfcAttributeDescription)attrArray[0];
            String name = aname.stringValue();
            ASN1SetOf avalue = (ASN1SetOf)attrArray[1];
            ASN1Object[] valueArray = avalue.toArray();
            LDAPAttribute attr = new LDAPAttribute(name);
            for (int v = 0; v < valueArray.length; ++v) {
                RfcAttributeValue rfcV = (RfcAttributeValue)valueArray[v];
                attr.addValue(rfcV.byteValue());
            }
            modifications[m] = new LDAPModification(op, attr);
        }
        return modifications;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPModifyRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPModifyRequest object");
        }
        LDAPModifyRequest tmp = (LDAPModifyRequest)readObject;
        String dn = tmp.getDN();
        LDAPModification[] mods = tmp.getModifications();
        tmp = null;
        RfcModifyRequest operation = new RfcModifyRequest(new RfcLDAPDN(dn), LDAPModifyRequest.encodeModifications(mods));
        this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        readObject = null;
    }
}

