/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupRelationMixin
extends LinkedInObjectMixin {
    @JsonCreator
    GroupRelationMixin(@JsonProperty(value="availableActions") @JsonDeserialize(using=AvailableActionDeserializer.class) List<Group.GroupAvailableAction> availableActions, @JsonProperty(value="membershipState") @JsonDeserialize(using=MembershipStateDeserializer.class) Group.MembershipState membershipState) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MembershipStateDeserializer
    extends JsonDeserializer<Group.MembershipState> {
        private MembershipStateDeserializer() {
        }

        public Group.MembershipState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node;
            if (jp.hasCurrentToken() && jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT) && (node = (JsonNode)jp.readValueAs(JsonNode.class)).has("code")) {
                return Group.MembershipState.valueOf(node.get("code").textValue().replace('-', '_').toUpperCase());
            }
            throw ctxt.mappingException("Expected JSON object");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AvailableActionDeserializer
    extends JsonDeserializer<List<Group.GroupAvailableAction>> {
        private AvailableActionDeserializer() {
        }

        public List<Group.GroupAvailableAction> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<Group.GroupAvailableAction> actions = new ArrayList<Group.GroupAvailableAction>();
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                for (JsonNode d : dataNode) {
                    String s = d.path("code").textValue();
                    if (s == null) continue;
                    actions.add(Group.GroupAvailableAction.valueOf(s.replace('-', '_').toUpperCase()));
                }
            }
            return actions;
        }
    }
}

